/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.sheet.undo;

import java.util.ArrayList;
import javax.swing.undo.AbstractUndoableEdit;
import org.dbdoclet.jive.sheet.Part;
import org.dbdoclet.jive.sheet.undo.PartData;

public abstract class AbstractPartEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    protected ArrayList<PartData> editList;

    public void addEditData(Part parent, Part child) {
        if (parent != null && child != null) {
            this.editList.add(new PartData(parent, child));
        }
    }

    @Override
    public String getPresentationName() {
        return this.getClass().getSimpleName() + "(" + this.hashCode() + "): EditList[" + this.editList + "]";
    }

    protected void addData() {
        for (PartData data : this.editList) {
            if (data.getIndex() == -1) {
                data.getParent().appendChild(data.getChild());
            } else {
                data.getParent().insertChild(data.getIndex(), data.getChild());
            }
            data.getParent().getSheet().updateView();
        }
    }

    protected void removeData() {
        for (PartData data : this.editList) {
            data.getParent().removeChild(data.getChild());
            data.getParent().getSheet().updateView();
        }
    }
}

