/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.sheet;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import org.dbdoclet.format.Alignment;
import org.dbdoclet.jive.sheet.AbstractPart;
import org.dbdoclet.jive.sheet.PaperFormat;
import org.dbdoclet.jive.sheet.Part;
import org.dbdoclet.jive.sheet.Sheet;
import org.dbdoclet.unit.Length;
import org.dbdoclet.unit.LengthUnit;
import org.dbdoclet.xiphias.XmlServices;
import org.w3c.dom.Element;

public class Text
extends AbstractPart {
    private String content;
    private Color color;
    private ArrayList<String> lines;
    private FontRenderContext frc;

    public Text(Sheet sheet, String content) {
        this(sheet, content, new Font("Times New Roman", 0, 12), Color.black, Alignment.CENTER);
    }

    public Text(Sheet sheet, String content, Font font, Color color, Alignment alignment) {
        super(sheet);
        this.content = content;
        this.font = font;
        this.color = color;
        this.alignment = alignment;
        this.lines = new ArrayList();
    }

    @Override
    public Part deepCopy(Sheet sheet) {
        Text copy = new Text(sheet, this.content, this.font, this.color, this.alignment);
        this.fillCopy(copy);
        return copy;
    }

    public Color getColor() {
        return this.color;
    }

    public String getContent() {
        return this.content;
    }

    @Override
    public double getNormalizedHeight() {
        double lineHeight = 0.0;
        lineHeight = this.frc == null ? new Length(this.font.getSize2D(), LengthUnit.POINT).toMillimeter() : new Length(this.font.getLineMetrics("M", this.frc).getHeight(), LengthUnit.POINT).toMillimeter();
        double normalizedHeight = lineHeight * (double)this.lines.size() * 1.023;
        return this.margin.getTop().toMillimeter() + this.padding.getTop().toMillimeter() + normalizedHeight + this.padding.getBottom().toMillimeter() + this.margin.getBottom().toMillimeter();
    }

    @Override
    public void paintPart(Graphics2D g2d) {
        this.frc = g2d.getFontRenderContext();
        double scaledFontSize = new Length((double)this.font.getSize() * this.sheet.getZoomFactor(), LengthUnit.POINT).toMillimeter();
        Font zoomedFont = this.font.deriveFont(new Double(scaledFontSize).floatValue());
        g2d.setFont(zoomedFont);
        g2d.setPaint(this.color);
        PaperFormat paperFormat = this.sheet.getPaperFormat();
        double printableWidth = paperFormat.getPrintableWidth().toMillimeter();
        double zoomedPrintableWidth = this.zoom(printableWidth);
        int zoomedFontHeight = this.computeFontHeight(g2d, zoomedFont);
        Rectangle bb = this.sheet.rzoom(this.getBoundingBox());
        int ypos = bb.y + zoomedFontHeight;
        int xpos = bb.x;
        int xmax = 0;
        this.content = XmlServices.normalizeText(this.content);
        Point point = new Point();
        for (String line : this.layoutText(g2d, zoomedFont, zoomedPrintableWidth, 0, this.content)) {
            if (this.alignment == Alignment.RIGHT) {
                xpos = bb.x + bb.width - this.computeStringWidth(g2d, zoomedFont, line);
            } else if (this.alignment == Alignment.LEFT) {
                xpos = bb.x;
            } else {
                xpos = bb.x + bb.width / 2;
                xpos -= this.computeStringWidth(g2d, zoomedFont, line) / 2;
            }
            g2d.drawString(line.trim(), xpos, ypos);
            point.y = ypos;
            point.x = xpos + this.computeStringWidth(g2d, zoomedFont, line.trim());
            if (point.x > xmax) {
                xmax = point.x;
            }
            ypos += zoomedFontHeight;
            bb.x = point.x;
        }
        this.boundingBox.height = this.getNormalizedHeight();
        this.updateBoxes();
        super.afterPaintPart(g2d);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public void writeElement(Element element) {
        super.writeElement(element);
        element.setTextContent(this.content);
        element.setAttribute("font", this.font.getFamily() + "-" + this.getFontStyle(this.font.getStyle()) + "-" + this.font.getSize());
        element.setAttribute("alignment", this.alignment.toString().toLowerCase());
    }

    private String getFontStyle(int style) {
        switch (style) {
            case 0: {
                return "plain";
            }
            case 1: {
                return "bold";
            }
            case 2: {
                return "italic";
            }
            case 3: {
                return "bold+italic";
            }
        }
        return "plain";
    }

    private ArrayList<String> layoutText(Graphics2D g2d, Font zoomedFont, double zoomedPrintableWidth, int xpos, String text) {
        this.lines = new ArrayList();
        int cursor = 0;
        int lineEnd = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c != ' ' && c != '\t' && c != '\n' && c != '\r') continue;
            String line = text.substring(cursor, i);
            int lineWidth = this.computeStringWidth(g2d, zoomedFont, line.trim());
            if ((double)(xpos + lineWidth) > zoomedPrintableWidth) {
                this.lines.add(text.substring(cursor, lineEnd).trim());
                cursor = lineEnd;
                xpos = 0;
                continue;
            }
            lineEnd = i;
        }
        if (this.lines.size() == 0) {
            this.lines.add(text);
        } else {
            this.lines.add(text.substring(cursor));
        }
        return this.lines;
    }
}

