/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.sheet;

import java.util.ArrayList;
import org.dbdoclet.jive.sheet.DocumentPart;
import org.dbdoclet.jive.sheet.Part;
import org.dbdoclet.jive.sheet.Sheet;
import org.dbdoclet.jive.sheet.Text;

public class SheetModel {
    private DocumentPart documentPart;
    private String header = "";
    private String footer = "";
    private int pageNumber = 1;

    public SheetModel(Sheet sheet) {
        this.documentPart = new DocumentPart(sheet);
    }

    public void addPart(Part part) {
        if (part == null) {
            return;
        }
        this.documentPart.appendChild(part);
    }

    public void clear() {
        this.documentPart.removeAll();
    }

    public SheetModel deepCopy(Sheet copySheet) {
        SheetModel copy = new SheetModel(copySheet);
        copy.setDocumentPart((DocumentPart)this.documentPart.deepCopy(copySheet));
        copy.setHeader(new String(this.header));
        copy.setFooter(new String(this.footer));
        copy.setPageNumber(this.pageNumber);
        return copy;
    }

    public DocumentPart getDocumentPart() {
        return this.documentPart;
    }

    public String getFooter() {
        return this.footer;
    }

    public String getHeader() {
        return this.header;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public Part getPart(int index) {
        ArrayList<Part> partList = this.documentPart.getChildren();
        if (partList == null || index < 0 || index >= partList.size()) {
            return null;
        }
        Part part = partList.get(index);
        return part;
    }

    public ArrayList<Part> getPartList() {
        ArrayList<Part> partList = this.documentPart.getChildren();
        return partList;
    }

    public ArrayList<Text> getTextList() {
        return this.getTextList(this.documentPart);
    }

    public ArrayList<Text> getTextList(Part part) {
        ArrayList<Text> textList = new ArrayList<Text>();
        if (part instanceof Text) {
            textList.add((Text)part);
        }
        for (Part child : part.getChildren()) {
            textList.addAll(this.getTextList(child));
        }
        return textList;
    }

    public void insertPart(Part newPart, int index) {
        this.documentPart.insertChild(index, newPart);
    }

    public void insertPartBefore(Part part, Part referencePart) {
        int index = 0;
        boolean found = false;
        for (Part p : this.getPartList()) {
            if (p == referencePart) {
                found = true;
                break;
            }
            ++index;
        }
        if (found) {
            this.documentPart.insertChild(index, part);
        }
    }

    public Part removePart(int index) {
        ArrayList<Part> partList = this.documentPart.getChildren();
        if (partList == null || index < 0 || index >= partList.size()) {
            return null;
        }
        return this.documentPart.removeChild(index);
    }

    public void removePart(Part part) {
        this.removePart(part, true);
    }

    public void removePart(Part part, boolean undoable) {
        this.documentPart.removeChild(part);
    }

    public void removePartById(String id) {
        Part foundPart = null;
        for (Part part : this.getPartList()) {
            if (part.getId() == null || part == null || !part.getId().equals(id)) continue;
            foundPart = part;
            break;
        }
        if (foundPart != null) {
            this.documentPart.removeChild(foundPart);
        }
    }

    public void setDocumentPart(DocumentPart documentPart) {
        this.documentPart = documentPart;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }
}

