/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.sheet;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import org.dbdoclet.format.Alignment;
import org.dbdoclet.jive.JiveConstants;
import org.dbdoclet.jive.RegionFrame;
import org.dbdoclet.jive.sheet.AbstractPart;
import org.dbdoclet.jive.sheet.DocumentPart;
import org.dbdoclet.jive.sheet.Margin;
import org.dbdoclet.jive.sheet.PaperFormat;
import org.dbdoclet.jive.sheet.PaperSize;
import org.dbdoclet.jive.sheet.Part;
import org.dbdoclet.jive.sheet.SheetContainer;
import org.dbdoclet.jive.sheet.SheetModel;
import org.dbdoclet.jive.sheet.Text;
import org.dbdoclet.unit.LengthUnit;
import org.w3c.dom.Element;

public class Sheet
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int alignment;
    private boolean autoZoom = false;
    private Color backgroundColor = Color.lightGray;
    private BasicStroke basicStroke = new BasicStroke(1.0f);
    private BasicStroke boldStroke = new BasicStroke(2.0f, 0, 2);
    private BasicStroke dashedStroke = new BasicStroke(1.0f, 1, 1, 10.0f, new float[]{5.0f, 5.0f}, 5.0f);
    private boolean desktopEnabled = true;
    private int desktopHeight = 320;
    private float desktopMargin = 10.0f;
    private int desktopWidth = 320;
    private RegionFrame displayMargins;
    private RegionFrame displayRegions;
    private boolean endlessPaperMode = false;
    private boolean fitToDesktopSize = false;
    private Color paperColor = Color.white;
    private double paperDisplayHeight;
    private double paperDisplayWidth;
    private PaperFormat paperFormat = PaperFormat.A4;
    private Rectangle selectionRectangle;
    private Color shadowColor = Color.darkGray;
    private boolean shadowEnabled = true;
    private int shadowLeftOffset = 1;
    private int shadowTopOffset = 1;
    private Font textFont;
    private boolean visibleMargins = false;
    private boolean visibleSpaceEnabled = false;
    private double zoomFactor = 1.0;
    protected SheetContainer container;
    protected SheetModel model;
    protected ResourceBundle res;

    public Sheet(SheetContainer container, ResourceBundle res) {
        this.container = container;
        this.res = res;
        this.setPaperFormat(new PaperFormat(PaperFormat.A4));
        this.textFont = new Font("Serif", 0, 12);
        this.model = new SheetModel(this);
        this.setFocusable(true);
    }

    public boolean contains(Part part) {
        Rectangle boundingBox = this.rzoom(part.getMarginBox());
        return !(boundingBox.getMaxY() > this.zoom(this.getBodyBottom()));
    }

    public Sheet deepCopy() {
        Sheet copy = new Sheet(this.container, this.res);
        this.deepCopy(copy);
        return copy;
    }

    public void drawSelectionRectangle(Rectangle newSelectionRectangle) {
        Rectangle refreshRectangle;
        if (newSelectionRectangle == null) {
            refreshRectangle = this.selectionRectangle;
        } else {
            refreshRectangle = (Rectangle)newSelectionRectangle.clone();
            if (this.selectionRectangle != null) {
                if (this.selectionRectangle.x < refreshRectangle.x) {
                    refreshRectangle.x = this.selectionRectangle.x;
                }
                if (this.selectionRectangle.y < refreshRectangle.y) {
                    refreshRectangle.y = this.selectionRectangle.y;
                }
                if (this.selectionRectangle.width > refreshRectangle.width) {
                    refreshRectangle.width = this.selectionRectangle.width;
                }
                if (this.selectionRectangle.height > refreshRectangle.height) {
                    refreshRectangle.height = this.selectionRectangle.height;
                }
            }
            if (newSelectionRectangle.width < 0) {
                newSelectionRectangle.width *= -1;
                newSelectionRectangle.x -= newSelectionRectangle.width;
            }
            if (newSelectionRectangle.height < 0) {
                newSelectionRectangle.height *= -1;
                newSelectionRectangle.y -= newSelectionRectangle.height;
            }
        }
        this.selectionRectangle = newSelectionRectangle;
        if (refreshRectangle != null) {
            refreshRectangle.x -= 3;
            refreshRectangle.y -= 3;
            refreshRectangle.width += 6;
            refreshRectangle.height += 6;
            this.repaint(refreshRectangle);
        }
    }

    public boolean endOfSheet(Part nextPart) {
        int cursorPos = 0;
        for (Part part : this.model.getPartList()) {
            cursorPos = (int)((double)cursorPos + (part.getSpaceBefore() + part.getNormalizedHeight() + part.getSpaceAfter()));
        }
        return (double)cursorPos + (nextPart.getNormalizedHeight() - nextPart.getSpaceAfter()) > this.paperFormat.getPrintableHeight().toMillimeter();
    }

    public void erase() {
        this.model.getPartList().clear();
    }

    public void fillElement(Element element) {
        element.setAttribute("paper-width", this.paperFormat.getSize().getWidth().toNormalizedString());
        element.setAttribute("paper-height", this.paperFormat.getSize().getHeight().toNormalizedString());
        element.setAttribute("paper-format", this.paperFormat.getName());
        element.setAttribute("orientation", this.paperFormat.getOrientation().toString().toLowerCase());
        element.setAttribute("margin-top", this.paperFormat.getMargins().getTop().toNormalizedString());
        element.setAttribute("margin-bottom", this.paperFormat.getMargins().getBottom().toNormalizedString());
        element.setAttribute("margin-left", this.paperFormat.getMargins().getLeft().toNormalizedString());
        element.setAttribute("margin-right", this.paperFormat.getMargins().getRight().toNormalizedString());
        element.setAttribute("region-top", this.paperFormat.getRegions().getTop().toNormalizedString());
        element.setAttribute("region-bottom", this.paperFormat.getRegions().getBottom().toNormalizedString());
        element.setAttribute("region-left", this.paperFormat.getRegions().getLeft().toNormalizedString());
        element.setAttribute("region-right", this.paperFormat.getRegions().getRight().toNormalizedString());
    }

    public Part findPart(Point point) {
        for (Part part : this.model.getPartList()) {
            Rectangle bb = this.rzoom(part.getMarginBox());
            if (!bb.contains(point)) continue;
            return part;
        }
        return null;
    }

    public Text findText(Point point) {
        for (Text part : this.model.getTextList()) {
            Rectangle bb = this.rzoom(part.getMarginBox());
            if (!bb.contains(point)) continue;
            return part;
        }
        return null;
    }

    public Text findTextById(String id) {
        if (id == null) {
            return null;
        }
        for (Part part : this.model.getPartList()) {
            String otherId = part.getId();
            if (otherId != null && id.equalsIgnoreCase(part.getId()) && part instanceof Text) {
                return (Text)part;
            }
            for (Part child : part.getChildren()) {
                otherId = child.getId();
                if (otherId == null || !id.equalsIgnoreCase(child.getId()) || !(child instanceof Text)) continue;
                return (Text)child;
            }
        }
        return null;
    }

    public String findTextContentById(String id) {
        Text text = this.findTextById(id);
        if (text != null) {
            return text.getContent();
        }
        return null;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public double getBodyBottom() {
        return this.getDesktopTop() + this.paperDisplayHeight - this.displayMargins.getBottom().toMillimeter() - this.displayRegions.getBottom().toMillimeter();
    }

    public double getBodyLeft() {
        return this.getDesktopLeft() + this.displayMargins.getLeft().toMillimeter() + this.displayRegions.getLeft().toMillimeter();
    }

    public double getBodyRight() {
        return this.getDesktopLeft() + this.paperDisplayWidth - this.displayMargins.getRight().toMillimeter() - this.displayRegions.getRight().toMillimeter();
    }

    public double getBodyTop() {
        return this.getDesktopTop() + this.displayMargins.getTop().toMillimeter() + this.displayRegions.getTop().toMillimeter();
    }

    public Stroke getBoldStroke() {
        return this.boldStroke;
    }

    public BasicStroke getDashedStroke() {
        return this.dashedStroke;
    }

    public int getDesktopHeight() {
        return this.desktopHeight;
    }

    public int getDesktopWidth() {
        return this.desktopWidth;
    }

    public Part getDocumentPart() {
        return this.model.getDocumentPart();
    }

    @Override
    public int getHeight() {
        if (!this.desktopEnabled) {
            return this.rzoom(this.paperDisplayHeight);
        }
        return this.rzoom(this.desktopHeight);
    }

    public String getId() {
        return String.valueOf(this.hashCode());
    }

    public RegionFrame getMargins() {
        return this.paperFormat.getMargins();
    }

    public SheetModel getModel() {
        return this.model;
    }

    public Color getPaperColor() {
        return this.paperColor;
    }

    public PaperFormat getPaperFormat() {
        PaperFormat copy = PaperFormat.valueOf(this.paperFormat.getSize());
        copy.setMargins(this.paperFormat.getMargins());
        copy.setRegions(this.paperFormat.getRegions());
        copy.setOrientation(this.paperFormat.getOrientation());
        return copy;
    }

    @Override
    public Dimension getPreferredSize() {
        Container container;
        int parentWidth;
        double ratio;
        if (this.autoZoom && (ratio = (double)(parentWidth = (container = this.getParent()).getWidth()) / (this.getDesktopLeft() + this.paperDisplayWidth + this.getDesktopRight())) > 1.0 && Math.abs(this.zoomFactor - ratio) > 0.1) {
            this.zoomFactor = ratio;
        }
        Dimension dim = new Dimension(this.getWidth(), this.getHeight());
        return dim;
    }

    public ResourceBundle getResourceBundle() {
        return this.res;
    }

    public ArrayList<Part> getSelectedPartList() {
        ArrayList<Part> selectedPartList = new ArrayList<Part>();
        for (Part part : this.model.getPartList()) {
            selectedPartList.addAll(this.getSelectedPartList(part));
        }
        return selectedPartList;
    }

    public ArrayList<Part> getSelectedPartList(Part part) {
        ArrayList<Part> selectedPartList = new ArrayList<Part>();
        if (part.isSelected()) {
            selectedPartList.add(part);
        }
        for (Part child : part.getChildren()) {
            selectedPartList.addAll(this.getSelectedPartList(child));
        }
        return selectedPartList;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    @Override
    public int getWidth() {
        if (!this.desktopEnabled) {
            return this.rzoom(this.paperDisplayWidth);
        }
        return this.rzoom(this.desktopWidth);
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void insertPart(Part text, int index) {
        this.model.insertPart(text, index);
    }

    public boolean isAutoZoom() {
        return this.autoZoom;
    }

    public boolean isEndlessPaperMode() {
        return this.endlessPaperMode;
    }

    public boolean isFitToDesktopSize() {
        return this.fitToDesktopSize;
    }

    public boolean isVisibleSpaceEnabled() {
        return this.visibleSpaceEnabled;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (this.desktopEnabled) {
            g2d.setPaint(this.backgroundColor);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.shadowEnabled) {
            g2d.setPaint(this.shadowColor);
            g2d.fillRect(this.rzoom(this.getDesktopLeft() + (double)this.getShadowLeftOffset()), this.rzoom(this.getDesktopTop() + (double)this.getShadowTopOffset()), this.rzoom(this.getPaperDisplayWidth()), this.rzoom(this.getPaperDisplayHeight()));
        }
        g2d.setPaint(this.paperColor);
        g2d.fillRect(this.rzoom(this.getDesktopLeft()), this.rzoom(this.getDesktopTop()), this.rzoom(this.getPaperDisplayWidth()), this.rzoom(this.getPaperDisplayHeight()));
        if (this.visibleMargins) {
            g2d.setStroke(this.dashedStroke);
            g2d.setPaint(Color.darkGray);
            g2d.drawRect(this.rzoom(this.getDesktopLeft() + this.displayMargins.getLeft().toMillimeter()), this.rzoom(this.getDesktopTop() + this.displayMargins.getTop().toMillimeter()), this.rzoom(this.getPaperDisplayWidth() - this.displayMargins.getRight().toMillimeter() - this.displayMargins.getLeft().toMillimeter()), this.rzoom(this.getPaperDisplayHeight() - this.displayMargins.getBottom().toMillimeter() - this.displayMargins.getTop().toMillimeter()));
            g2d.setPaint(Color.green);
            g2d.drawRect(this.rzoom(this.getDesktopLeft() + this.displayMargins.getLeft().toMillimeter()), this.rzoom(this.getDesktopTop() + this.displayMargins.getTop().toMillimeter()), this.rzoom(this.getPaperDisplayWidth() - this.displayMargins.getRight().toMillimeter() - this.displayMargins.getLeft().toMillimeter()), this.rzoom(this.displayRegions.getTop().toMillimeter()));
        }
        DocumentPart documentPart = this.model.getDocumentPart();
        documentPart.setBoundingBox(new Rectangle2D.Double(this.getBodyLeft(), this.getBodyTop(), this.getBodyRight() - this.getBodyLeft(), this.getBodyBottom() - this.getBodyTop()));
        documentPart.paintPart(g2d);
        this.paintHeader(g2d);
        this.paintPageNumber(g2d);
        this.paintSelectionRectangle(g2d);
        if (this.hasFocus()) {
            g2d.setPaint(Color.black);
            g2d.setStroke(this.boldStroke);
            g2d.drawRect(0, 0, this.getWidth(), this.getHeight());
        }
        int lastYPos = (int)Math.round(documentPart.getCursor().getTop() + (double)(2.0f * this.desktopMargin) + this.paperFormat.getMargins().getBottom().toMillimeter() + this.paperFormat.getRegions().getBottom().toMillimeter());
        if (this.endlessPaperMode && this.desktopHeight != lastYPos && (double)lastYPos > this.paperFormat.getHeight().toMillimeter()) {
            this.setDesktopSize(this.desktopWidth, lastYPos);
        }
    }

    public void paintSelectionMarker(Graphics2D g2d, Part part) {
        Color selectionColor = new Color(0, 80, 0);
        g2d.setPaint(selectionColor);
        g2d.setStroke(this.boldStroke);
        Rectangle bb = this.rzoom(part.getMarginBox());
        int length = 5;
        int lineWidth = Math.round(this.boldStroke.getLineWidth() - 1.0f);
        g2d.drawLine(bb.x, bb.y, bb.x, bb.y + this.rzoom(length));
        g2d.drawLine(bb.x - lineWidth, bb.y, bb.x + this.rzoom(length), bb.y);
        g2d.drawLine(bb.x + bb.width - this.rzoom(length), bb.y + bb.height, bb.x + bb.width, bb.y + bb.height);
        g2d.drawLine(bb.x + bb.width, bb.y + bb.height + lineWidth, bb.x + bb.width, bb.y + bb.height - this.rzoom(length));
    }

    public void readSheet(Element element) {
    }

    public int rzoom(double value) {
        return (int)Math.round(this.zoomFactor * value);
    }

    public Rectangle rzoom(Rectangle2D.Double rect2D) {
        return this.rzoom(rect2D, 1.0);
    }

    public Rectangle rzoom(Rectangle2D.Double rect2D, double factor) {
        Rectangle rect = new Rectangle();
        if (factor != 1.0) {
            double owidth = rect2D.width;
            double oheight = rect2D.height;
            double nwidth = rect2D.width * factor;
            double nheight = rect2D.height * factor;
            double xdiff = (nwidth - owidth) / 2.0;
            double ydiff = (nheight - oheight) / 2.0;
            rect.x = this.rzoom(rect2D.x - xdiff);
            rect.y = this.rzoom(rect2D.y - ydiff);
            rect.width = this.rzoom(nwidth);
            rect.height = this.rzoom(nheight);
        } else {
            rect.x = this.rzoom(rect2D.x);
            rect.y = this.rzoom(rect2D.y);
            rect.width = this.rzoom(rect2D.width);
            rect.height = this.rzoom(rect2D.height);
        }
        return rect;
    }

    public void setAlign(int alignment) {
        this.alignment = alignment;
    }

    public void setAutoZoom(boolean autoZoom) {
        this.autoZoom = autoZoom;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setDesktopEnabled(boolean desktopEnabled) {
        this.desktopEnabled = desktopEnabled;
    }

    public void setDesktopMargin(float desktopMargin) {
        this.desktopMargin = desktopMargin;
    }

    public void setDesktopSize(int desktopWidth, int desktopHeight) {
        if (desktopWidth < 0) {
            throw new IllegalArgumentException("Invalid desktop width of " + desktopWidth + "!");
        }
        if (desktopHeight < 0) {
            throw new IllegalArgumentException("Invalid desktop height of " + desktopHeight + "!");
        }
        this.desktopHeight = desktopHeight;
        this.desktopWidth = desktopWidth;
        this.updateView();
    }

    public void setEndlessPaperMode(boolean endlessPaperMode) {
        this.endlessPaperMode = endlessPaperMode;
    }

    public void setFitToDesktopSize(boolean fitToDesktopSize) {
        this.fitToDesktopSize = fitToDesktopSize;
        if (fitToDesktopSize) {
            this.fitToDesktopSize();
        }
    }

    public void setMargins(RegionFrame margins) {
        this.paperFormat.setMargins(margins);
        this.updateView();
    }

    public void setModel(SheetModel model) {
        this.model = model;
    }

    public void setPaperColor(Color paperColor) {
        this.paperColor = paperColor;
    }

    public void setPaperFormat(PaperFormat paperFormat) {
        this.paperFormat = paperFormat;
        this.updateView();
    }

    public void setPaperSize(PaperSize paperSize) {
        this.paperFormat.setSize(paperSize);
        this.updateView();
    }

    public void setScalePaperToPoint(double imageableWidth, double imageableHeight) {
        double ratio2;
        double ratio1 = imageableWidth / this.paperFormat.getPrintableWidth().toMillimeter();
        double ratio = ratio1 > (ratio2 = imageableHeight / this.paperFormat.getPrintableHeight().toMillimeter()) ? ratio2 : ratio1;
        this.setZoomFactor((float)ratio);
        this.setPaperSize(new PaperSize(this.pointToMm(imageableWidth), this.pointToMm(imageableHeight), LengthUnit.MILLIMETER));
        this.recalculate();
    }

    public void setSelection(Point point, boolean isShiftDown, boolean isControlDown) {
        this.drawSelectionRectangle(null);
        for (Part part : this.model.getPartList()) {
            this.setSelection(point, part, isShiftDown, isControlDown);
        }
    }

    public boolean setSelection(Point point, Part part, boolean isShiftDown, boolean isControlDown) {
        if (point == null) {
            part.setSelected(false);
        } else {
            for (Part child : part.getChildren()) {
                if (!this.setSelection(point, child, isShiftDown, isControlDown)) continue;
                return true;
            }
            if (this.rzoom(part.getMarginBox()).contains(point)) {
                if (!part.isSelected()) {
                    part.setSelected(true);
                    this.repaint(this.rzoom(part.getMarginBox()));
                    return true;
                }
            } else if (part.isSelected() && !isControlDown) {
                part.setSelected(false);
                this.repaint(this.rzoom(part.getMarginBox()));
            }
        }
        return false;
    }

    public void setSelection(Rectangle rect) {
        this.drawSelectionRectangle(null);
        for (Part part : this.model.getPartList()) {
            this.setSelection(rect, part);
        }
    }

    public void setSelection(Rectangle rect, Part part) {
        if (rect == null) {
            part.setSelected(false);
        } else {
            if (rect.contains(this.rzoom(part.getMarginBox()))) {
                if (!part.isSelected()) {
                    part.setSelected(true);
                    this.repaint(this.rzoom(part.getMarginBox(), 2.0));
                }
            } else if (part.isSelected()) {
                part.setSelected(false);
                this.repaint(this.rzoom(part.getMarginBox(), 2.0));
            }
            for (Part child : part.getChildren()) {
                this.setSelection(rect, child);
            }
        }
    }

    public void setShadowEnabled(boolean shadowEnabled) {
        this.shadowEnabled = shadowEnabled;
    }

    public void setVisibleMargins(boolean visibleMargins) {
        this.visibleMargins = visibleMargins;
    }

    public void setVisibleSpaceEnabled(boolean visibleSpaceEnabled) {
        this.visibleSpaceEnabled = visibleSpaceEnabled;
    }

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    @Override
    public String toString() {
        return "Sheet(" + this.hashCode() + ") zoomFactor=" + this.getZoomFactor();
    }

    public int unzoom(double value) {
        return (int)Math.round(value / this.zoomFactor);
    }

    public void updateView() {
        this.recalculate();
        this.validateAndRepaint();
    }

    public void validateAndRepaint() {
        this.validate();
        this.repaint();
    }

    public double zoom(double value) {
        return this.zoomFactor * value;
    }

    private void fitToDesktopSize() {
        double paperWidth = this.paperFormat.getWidth().toMillimeter();
        double paperHeight = this.paperFormat.getHeight().toMillimeter();
        if (this.endlessPaperMode) {
            paperHeight = this.getDesktopHeight();
        }
        double widthRatio = (double)((float)this.desktopWidth - 2.0f * this.desktopMargin) / paperWidth;
        double heightRatio = (double)((float)this.desktopHeight - 2.0f * this.desktopMargin) / paperHeight;
        double ratio = widthRatio;
        if (heightRatio < widthRatio) {
            ratio = heightRatio;
        }
        this.paperDisplayWidth = Math.round(ratio * paperWidth);
        this.paperDisplayHeight = Math.round(ratio * paperHeight);
        this.displayMargins.scale(ratio);
        this.displayRegions.scale(ratio);
    }

    private double getDesktopLeft() {
        if (!this.desktopEnabled) {
            return 0.0;
        }
        return ((double)this.desktopWidth - this.paperDisplayWidth) / 2.0;
    }

    private double getDesktopRight() {
        if (!this.desktopEnabled) {
            return 0.0;
        }
        return ((double)this.desktopWidth - this.paperDisplayWidth) / 2.0;
    }

    private double getDesktopTop() {
        if (!this.desktopEnabled) {
            return 0.0;
        }
        double topX = ((double)this.desktopHeight - this.paperDisplayHeight) / 2.0;
        if (this.alignment == 1 && topX > (double)this.desktopMargin) {
            topX = this.desktopMargin;
        }
        return topX;
    }

    private double getPaperDisplayHeight() {
        return this.paperDisplayHeight;
    }

    private double getPaperDisplayWidth() {
        return this.paperDisplayWidth;
    }

    private int getShadowLeftOffset() {
        return this.shadowLeftOffset;
    }

    private int getShadowTopOffset() {
        return this.shadowTopOffset;
    }

    private void paintHeader(Graphics2D g2d) {
        String header = String.valueOf(this.model.getHeader());
        if (header == null || header.trim().length() == 0) {
            return;
        }
        Font regionFont = this.textFont.deriveFont(12.0f);
        FontMetrics fm = g2d.getFontMetrics(regionFont);
        g2d.setFont(regionFont);
        g2d.setPaint(Color.black);
        double printableWidth = this.paperFormat.getPrintableWidth().toMillimeter();
        long center = Math.round(this.paperFormat.getMargins().getLeft().toMillimeter() + printableWidth / 2.0);
        long ypos = Math.round(this.getDesktopTop() + this.displayMargins.getTop().toMillimeter() + this.displayRegions.getTop().toMillimeter());
        int yMiddle = this.rzoom(this.displayRegions.getTop().toMillimeter()) - fm.getHeight() / 2;
        g2d.drawString(header, this.rzoom(center) - fm.stringWidth(header) / 2, this.rzoom(ypos) - yMiddle);
    }

    private void paintPageNumber(Graphics2D g2d) {
        Font regionFont = this.textFont.deriveFont(8.0f);
        FontMetrics fm = g2d.getFontMetrics(regionFont);
        g2d.setFont(regionFont);
        g2d.setPaint(Color.black);
        String pageNumberText = String.valueOf(this.model.getPageNumber());
        g2d.drawString(pageNumberText, this.rzoom(this.getDesktopLeft() + this.getPaperDisplayWidth() - this.displayMargins.getRight().toMillimeter()) - fm.stringWidth(pageNumberText), this.rzoom(this.getPaperDisplayHeight() - this.displayMargins.getBottom().toMillimeter()));
    }

    private void paintSelectionRectangle(Graphics2D g2d) {
        if (this.selectionRectangle != null) {
            g2d.setPaint(JiveConstants.COLOUR_SAND);
            Composite originalComposite = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, 0.33f));
            g2d.fillRect(this.selectionRectangle.x, this.selectionRectangle.y, this.selectionRectangle.width, this.selectionRectangle.height);
            g2d.setComposite(originalComposite);
            g2d.setStroke(this.basicStroke);
            g2d.drawRect(this.selectionRectangle.x, this.selectionRectangle.y, this.selectionRectangle.width, this.selectionRectangle.height);
        }
    }

    private float pointToMm(double imageableWidth) {
        return (float)(imageableWidth / 72.0) * 25.4f;
    }

    private void recalculate() {
        this.paperDisplayWidth = this.paperFormat.getWidth().toMillimeter();
        this.paperDisplayHeight = this.paperFormat.getHeight().toMillimeter();
        this.displayMargins = this.paperFormat.getMargins();
        this.displayRegions = this.paperFormat.getRegions();
        if (this.fitToDesktopSize) {
            this.fitToDesktopSize();
        }
    }

    protected void deepCopy(Sheet copy) {
        copy.setPaperFormat(this.getPaperFormat());
        copy.setZoomFactor(this.getZoomFactor());
        copy.setAutoZoom(this.isAutoZoom());
        copy.setFitToDesktopSize(this.isFitToDesktopSize());
        copy.setAlign(this.alignment);
        copy.setDesktopSize(this.desktopWidth, this.desktopHeight);
        copy.setDesktopMargin(this.desktopMargin);
        copy.setModel(this.model.deepCopy(copy));
        for (MouseListener mouseListener : this.getMouseListeners()) {
            copy.addMouseListener(mouseListener);
        }
    }

    protected void readCommonAttributes(Element child, AbstractPart part) {
        String value = child.getAttribute("id");
        if (value != null && value.trim().length() > 0) {
            part.setId(value);
        }
        if ((value = child.getAttribute("margin")) != null) {
            part.setMargin(Margin.valueOf(value));
        }
    }

    protected Part readText(Element child) {
        Text text = new Text(this, child.getTextContent());
        this.readCommonAttributes(child, text);
        String value = child.getAttribute("font");
        if (value != null) {
            Font font = Font.decode(value);
            text.setFont(font);
        }
        try {
            value = child.getAttribute("alignment");
            if (value != null) {
                text.setAlignment(Alignment.valueOf(value.toUpperCase()));
            }
            if ((value = child.getAttribute("margin")) != null) {
                text.setMargin(Margin.valueOf(value.toUpperCase()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return text;
    }
}

