/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.sheet;

import org.dbdoclet.unit.Length;
import org.dbdoclet.unit.LengthUnit;

public class PaperSize {
    public static PaperSize A0 = new PaperSize(841.0, 1189.0, LengthUnit.MILLIMETER);
    public static PaperSize A1 = new PaperSize(594.0, 841.0, LengthUnit.MILLIMETER);
    public static PaperSize A2 = new PaperSize(420.0, 594.0, LengthUnit.MILLIMETER);
    public static PaperSize A3 = new PaperSize(297.0, 420.0, LengthUnit.MILLIMETER);
    public static PaperSize A4 = new PaperSize(210.0, 297.0, LengthUnit.MILLIMETER);
    public static PaperSize A5 = new PaperSize(148.0, 210.0, LengthUnit.MILLIMETER);
    public static PaperSize A6 = new PaperSize(105.0, 148.0, LengthUnit.MILLIMETER);
    public static PaperSize A7 = new PaperSize(74.0, 105.0, LengthUnit.MILLIMETER);
    public static PaperSize A8 = new PaperSize(52.0, 74.0, LengthUnit.MILLIMETER);
    public static PaperSize A9 = new PaperSize(37.0, 52.0, LengthUnit.MILLIMETER);
    public static PaperSize A10 = new PaperSize(26.0, 37.0, LengthUnit.MILLIMETER);
    public static PaperSize B0 = new PaperSize(1000.0, 1414.0, LengthUnit.MILLIMETER);
    public static PaperSize B1 = new PaperSize(707.0, 1000.0, LengthUnit.MILLIMETER);
    public static PaperSize B2 = new PaperSize(500.0, 707.0, LengthUnit.MILLIMETER);
    public static PaperSize B3 = new PaperSize(353.0, 500.0, LengthUnit.MILLIMETER);
    public static PaperSize B4 = new PaperSize(250.0, 353.0, LengthUnit.MILLIMETER);
    public static PaperSize B5 = new PaperSize(176.0, 250.0, LengthUnit.MILLIMETER);
    public static PaperSize B6 = new PaperSize(125.0, 176.0, LengthUnit.MILLIMETER);
    public static PaperSize B7 = new PaperSize(88.0, 125.0, LengthUnit.MILLIMETER);
    public static PaperSize B8 = new PaperSize(62.0, 88.0, LengthUnit.MILLIMETER);
    public static PaperSize B9 = new PaperSize(44.0, 62.0, LengthUnit.MILLIMETER);
    public static PaperSize B10 = new PaperSize(31.0, 44.0, LengthUnit.MILLIMETER);
    public static PaperSize C0 = new PaperSize(917.0, 1297.0, LengthUnit.MILLIMETER);
    public static PaperSize C1 = new PaperSize(648.0, 917.0, LengthUnit.MILLIMETER);
    public static PaperSize C2 = new PaperSize(458.0, 648.0, LengthUnit.MILLIMETER);
    public static PaperSize C3 = new PaperSize(324.0, 458.0, LengthUnit.MILLIMETER);
    public static PaperSize C4 = new PaperSize(229.0, 324.0, LengthUnit.MILLIMETER);
    public static PaperSize C5 = new PaperSize(162.0, 229.0, LengthUnit.MILLIMETER);
    public static PaperSize C6 = new PaperSize(114.0, 162.0, LengthUnit.MILLIMETER);
    public static PaperSize C7 = new PaperSize(81.0, 114.0, LengthUnit.MILLIMETER);
    public static PaperSize C8 = new PaperSize(57.0, 81.0, LengthUnit.MILLIMETER);
    public static PaperSize C9 = new PaperSize(40.0, 57.0, LengthUnit.MILLIMETER);
    public static PaperSize C10 = new PaperSize(28.0, 40.0, LengthUnit.MILLIMETER);
    public static PaperSize Gro\u00dfpartitur1 = new PaperSize(420.0, 680.0, LengthUnit.MILLIMETER);
    public static PaperSize Gro\u00dfpartitur2 = new PaperSize(300.0, 420.0, LengthUnit.MILLIMETER);
    public static PaperSize Gro\u00dfpartitur3 = new PaperSize(300.0, 400.0, LengthUnit.MILLIMETER);
    public static PaperSize Gro\u00dfpartitur4 = new PaperSize(285.0, 400.0, LengthUnit.MILLIMETER);
    public static PaperSize Gro\u00dfpartitur5 = new PaperSize(300.0, 390.0, LengthUnit.MILLIMETER);
    public static PaperSize Gro\u00dfpartitur6 = new PaperSize(290.0, 350.0, LengthUnit.MILLIMETER);
    public static PaperSize Quartformat = new PaperSize(270.0, 340.0, LengthUnit.MILLIMETER);
    public static PaperSize QuartformatUS = new PaperSize(215.0, 275.0, LengthUnit.MILLIMETER);
    public static PaperSize OrgelformatBach = new PaperSize(330.0, 260.0, LengthUnit.MILLIMETER);
    public static PaperSize OrgelformatPeters1 = new PaperSize(300.0, 230.0, LengthUnit.MILLIMETER);
    public static PaperSize OrgelformatPeters2 = new PaperSize(305.0, 220.0, LengthUnit.MILLIMETER);
    public static PaperSize OrgelformatSteingr\u00e4ber = new PaperSize(265.0, 220.0, LengthUnit.MILLIMETER);
    public static PaperSize Bachformat = new PaperSize(240.0, 325.0, LengthUnit.MILLIMETER);
    public static PaperSize Oktavformat = new PaperSize(170.0, 270.0, LengthUnit.MILLIMETER);
    public static PaperSize OktavformatUS = new PaperSize(171.0, 267.0, LengthUnit.MILLIMETER);
    public static PaperSize Studienpartitur = new PaperSize(170.0, 240.0, LengthUnit.MILLIMETER);
    public static PaperSize Salonorchester = new PaperSize(190.0, 290.0, LengthUnit.MILLIMETER);
    public static PaperSize Klavierauszug = new PaperSize(190.0, 270.0, LengthUnit.MILLIMETER);
    public static PaperSize Klavierformat = new PaperSize(235.0, 310.0, LengthUnit.MILLIMETER);
    public static PaperSize Gro\u00dfmarsch = new PaperSize(135.0, 190.0, LengthUnit.MILLIMETER);
    public static PaperSize Marschformat = new PaperSize(135.0, 170.0, LengthUnit.MILLIMETER);
    public static PaperSize USLetter = new PaperSize(8.5, 11.0, LengthUnit.INCH);
    public static PaperSize USLegal = new PaperSize(8.5, 14.0, LengthUnit.INCH);
    public static PaperSize USExecutive = new PaperSize(7.2f, 10.5, LengthUnit.INCH);
    private Length width;
    private Length height;

    public PaperSize(double widthLength, double heightLength, LengthUnit unit) {
        this.width = new Length(widthLength, unit);
        this.height = new Length(heightLength, unit);
    }

    public PaperSize(Length width, Length height) {
        this.width = width;
        this.height = height;
    }

    public PaperSize deepCopy() {
        PaperSize copy = new PaperSize(this.width, this.height);
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PaperSize other = (PaperSize)obj;
        if (this.height == null && other.height != null) {
            return false;
        }
        if (!this.height.equals(other.height)) {
            return false;
        }
        if (this.width == null && other.width != null) {
            return false;
        }
        return this.width.equals(other.width);
    }

    public Length getHeight() {
        return this.height;
    }

    public String getHeightAsText() {
        return String.format("%.2f %s", Float.valueOf(this.height.getLength()), this.height.getUnit().getAbbreviation());
    }

    public Length getWidth() {
        return this.width;
    }

    public String getWidthAsText() {
        return String.format("%.2f %s", Float.valueOf(this.width.getLength()), this.width.getUnit().getAbbreviation());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.height == null ? 0 : this.height.hashCode());
        result = 31 * result + (this.width == null ? 0 : this.width.hashCode());
        return result;
    }

    public void setHeight(Length height) {
        this.height = height;
    }

    public void setWidth(Length width) {
        this.width = width;
    }

    public void swap() {
        Length tmp = this.width;
        this.width = this.height;
        this.height = tmp;
    }

    public String toString() {
        String unitAbbrev = this.width.getUnit().getAbbreviation();
        if (!this.width.getUnit().equals((Object)this.height.getUnit())) {
            unitAbbrev = String.format("%s\u00d7%s", this.width.getUnit().getAbbreviation(), this.height.getUnit().getAbbreviation());
        }
        return String.format("%.2f\u00d7%.2f%s", Float.valueOf(this.width.getLength()), Float.valueOf(this.height.getLength()), unitAbbrev);
    }
}

