/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.sheet;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.dbdoclet.jive.Anchor;
import org.dbdoclet.jive.Fill;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.RegionFrame;
import org.dbdoclet.jive.dialog.DataDialog;
import org.dbdoclet.jive.dialog.DialogAction;
import org.dbdoclet.jive.sheet.PaperFormat;
import org.dbdoclet.jive.sheet.PaperFormatComboBox;
import org.dbdoclet.jive.sheet.PaperSize;
import org.dbdoclet.jive.sheet.Sheet;
import org.dbdoclet.jive.sheet.SheetContainer;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.service.ResourceServices;
import org.dbdoclet.unit.Length;
import org.dbdoclet.unit.LengthUnit;

public class PaperFormatDialog
extends DataDialog
implements ActionListener,
ChangeListener,
SheetContainer {
    private static final long serialVersionUID = 1L;
    private PaperFormatComboBox formatComboBox;
    private JRadioButton orientationPortrait;
    private JRadioButton orientationLandscape;
    private JSpinner widthSpinner;
    private JSpinner heightSpinner;
    private JSpinner leftMarginSpinner;
    private JSpinner rightMarginSpinner;
    private JSpinner topMarginSpinner;
    private JSpinner bottomMarginSpinner;
    private Sheet sheet;
    private PaperFormat paperFormat = new PaperFormat(PaperFormat.A4);

    public PaperFormatDialog(Frame parent, String title) {
        super(parent, title);
    }

    public void createGui() {
        JiveFactory jive = JiveFactory.getInstance();
        GridPanel panel = this.getGridPanel();
        GridPanel dataPanel = new GridPanel();
        panel.addComponent((JComponent)dataPanel, Anchor.NORTHWEST, Fill.NONE);
        GridPanel previewPanel = new GridPanel();
        panel.addComponent((JComponent)previewPanel, Anchor.NORTHWEST, Fill.BOTH);
        dataPanel.startSubPanel(Fill.HORIZONTAL);
        dataPanel.addSeparator(1, ResourceServices.getString(this.res, "paper.format"));
        dataPanel.startSubPanel();
        this.formatComboBox = new PaperFormatComboBox();
        this.formatComboBox.addActionListener(this);
        this.formatComboBox.setUserDefinedLabel(ResourceServices.getString(this.res, "user_defined"));
        dataPanel.addLabeledComponent(ResourceServices.getString(this.res, "format"), (JComponent)this.formatComboBox);
        dataPanel.incrRow();
        this.widthSpinner = jive.createDistanceSpinner();
        this.widthSpinner.addChangeListener(this);
        dataPanel.addLabeledComponent(ResourceServices.getString(this.res, "width"), (JComponent)this.widthSpinner);
        dataPanel.incrRow();
        this.heightSpinner = jive.createDistanceSpinner();
        this.heightSpinner.addChangeListener(this);
        dataPanel.addLabeledComponent(ResourceServices.getString(this.res, "height"), (JComponent)this.heightSpinner);
        dataPanel.startSubPanel();
        this.orientationPortrait = new JRadioButton(ResourceServices.getString(this.res, "paper.orientation.portrait"));
        this.orientationPortrait.addActionListener(this);
        this.orientationPortrait.setSelected(true);
        dataPanel.addComponent(this.orientationPortrait);
        this.orientationLandscape = new JRadioButton(ResourceServices.getString(this.res, "paper.orientation.landscape"));
        this.orientationLandscape.addActionListener(this);
        dataPanel.addComponent(this.orientationLandscape);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.orientationPortrait);
        buttonGroup.add(this.orientationLandscape);
        dataPanel.startSubPanel(Fill.HORIZONTAL);
        dataPanel.addSeparator(1, ResourceServices.getString(this.res, "paper.margins"));
        dataPanel.startSubPanel();
        this.leftMarginSpinner = jive.createDistanceSpinner(Length.valueOf("1.0 cm"));
        this.leftMarginSpinner.addChangeListener(this);
        dataPanel.addLabeledComponent(ResourceServices.getString(this.res, "left"), (JComponent)this.leftMarginSpinner);
        this.rightMarginSpinner = jive.createDistanceSpinner(Length.valueOf("1.0 cm"));
        this.rightMarginSpinner.addChangeListener(this);
        dataPanel.addLabeledComponent(ResourceServices.getString(this.res, "right"), (JComponent)this.rightMarginSpinner);
        dataPanel.incrRow();
        this.topMarginSpinner = jive.createDistanceSpinner(Length.valueOf("1.0 cm"));
        this.topMarginSpinner.addChangeListener(this);
        dataPanel.addLabeledComponent(ResourceServices.getString(this.res, "top"), (JComponent)this.topMarginSpinner);
        this.bottomMarginSpinner = jive.createDistanceSpinner(Length.valueOf("1.0 cm"));
        this.bottomMarginSpinner.addChangeListener(this);
        dataPanel.addLabeledComponent(ResourceServices.getString(this.res, "bottom"), (JComponent)this.bottomMarginSpinner);
        dataPanel.startSubPanel(Fill.BOTH);
        this.sheet = jive.createSheet(this);
        this.sheet.setMinimumSize(new Dimension(this.sheet.getDesktopWidth(), this.sheet.getDesktopHeight()));
        this.sheet.setPreferredSize(new Dimension(this.sheet.getDesktopWidth(), this.sheet.getDesktopHeight()));
        this.sheet.setAutoZoom(false);
        this.sheet.setFitToDesktopSize(true);
        this.sheet.setVisibleMargins(true);
        previewPanel.addComponent(this.sheet);
        JButton button = new JButton(ResourceServices.getString(this.res, "C_OK"));
        button.setMnemonic(79);
        button.setName("OkButton");
        button.setActionCommand("ok");
        button.addActionListener(this);
        panel.addButton(button);
        button = new JButton(ResourceServices.getString(this.res, "C_CANCEL"));
        button.setActionCommand("cancel");
        button.addActionListener(this);
        panel.addButton(button);
        panel.prepare();
        if (this.paperFormat != null) {
            if (this.formatComboBox.contains(this.paperFormat)) {
                this.formatComboBox.setSelectedItem(PaperFormat.valueOf(this.paperFormat.getSize()));
            }
            Length width = this.paperFormat.getWidth();
            Length height = this.paperFormat.getHeight();
            if (this.paperFormat.getOrientation() == PaperFormat.Orientation.LANDSCAPE) {
                this.orientationLandscape.setSelected(true);
                this.widthSpinner.setValue(height);
                this.heightSpinner.setValue(width);
            }
            this.topMarginSpinner.setValue(this.paperFormat.getMargins().getTop());
            this.rightMarginSpinner.setValue(this.paperFormat.getMargins().getRight());
            this.bottomMarginSpinner.setValue(this.paperFormat.getMargins().getBottom());
            this.leftMarginSpinner.setValue(this.paperFormat.getMargins().getLeft());
        }
        this.pack();
        this.center(this.getParentWindow());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == null) {
            return;
        }
        if (source == this.formatComboBox) {
            this.updateFormat(source);
            return;
        }
        if (source == this.orientationPortrait || source == this.orientationLandscape) {
            this.updateFormat(source);
            return;
        }
        String cmd = event.getActionCommand();
        if (cmd == null) {
            return;
        }
        if (cmd.equals("ok")) {
            this.setPerformedAction(DialogAction.OK);
            this.setVisible(false);
        }
        if (cmd.equals("cancel")) {
            this.setPerformedAction(DialogAction.CANCEL);
            this.setVisible(false);
        }
    }

    private void updateFormat(Object source) {
        Length height;
        Length width;
        PaperFormat selectedFormat;
        if (source == this.formatComboBox && (selectedFormat = (PaperFormat)this.formatComboBox.getSelectedItem()) != PaperFormat.USER_DEFINED) {
            if (this.orientationPortrait.isSelected()) {
                this.widthSpinner.removeChangeListener(this);
                this.widthSpinner.setValue(selectedFormat.getWidth());
                this.widthSpinner.addChangeListener(this);
                this.heightSpinner.removeChangeListener(this);
                this.heightSpinner.setValue(selectedFormat.getHeight());
                this.heightSpinner.addChangeListener(this);
            } else {
                this.widthSpinner.removeChangeListener(this);
                this.widthSpinner.setValue(selectedFormat.getHeight());
                this.widthSpinner.addChangeListener(this);
                this.heightSpinner.removeChangeListener(this);
                this.heightSpinner.setValue(selectedFormat.getWidth());
                this.heightSpinner.addChangeListener(this);
            }
        }
        if (source == this.widthSpinner || source == this.heightSpinner) {
            width = (Length)this.widthSpinner.getValue();
            height = (Length)this.heightSpinner.getValue();
            PaperFormat paperFormat = PaperFormat.valueOf(new PaperSize(width, height));
            this.formatComboBox.removeActionListener(this);
            if (paperFormat.isUserDefined()) {
                this.formatComboBox.setSelectedItem(PaperFormat.USER_DEFINED);
            } else {
                this.formatComboBox.setSelectedItem(paperFormat);
            }
            this.formatComboBox.addActionListener(this);
        }
        if (source == this.orientationPortrait || source == this.orientationLandscape) {
            width = (Length)this.widthSpinner.getValue();
            height = (Length)this.heightSpinner.getValue();
            Length tmp = width;
            width = height;
            height = tmp;
            this.widthSpinner.removeChangeListener(this);
            this.widthSpinner.setValue(width);
            this.widthSpinner.addChangeListener(this);
            this.heightSpinner.removeChangeListener(this);
            this.heightSpinner.setValue(height);
            this.heightSpinner.addChangeListener(this);
        }
        width = (Length)this.widthSpinner.getValue();
        height = (Length)this.heightSpinner.getValue();
        this.sheet.setPaperSize(new PaperSize(width, height));
        this.validate();
        this.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        Object source = event.getSource();
        if (source == null) {
            return;
        }
        if (source == this.leftMarginSpinner || source == this.rightMarginSpinner || source == this.topMarginSpinner || source == this.bottomMarginSpinner) {
            this.sheet.setMargins(new RegionFrame((Length)this.topMarginSpinner.getValue(), (Length)this.rightMarginSpinner.getValue(), (Length)this.bottomMarginSpinner.getValue(), (Length)this.leftMarginSpinner.getValue()));
        }
        if (source == this.widthSpinner || source == this.heightSpinner) {
            this.updateFormat(source);
        }
    }

    public PaperFormat getPaperFormat() {
        PaperFormat paperFormat = new PaperFormat("", new PaperSize(Length.toMillimeter(this.widthSpinner.getValue()), Length.toMillimeter(this.heightSpinner.getValue()), LengthUnit.MILLIMETER));
        if (this.orientationLandscape.isSelected()) {
            paperFormat.setOrientation(PaperFormat.Orientation.LANDSCAPE);
        } else {
            paperFormat.setOrientation(PaperFormat.Orientation.PORTRAIT);
        }
        paperFormat.setMargins(this.sheet.getMargins());
        return paperFormat;
    }

    public void setPaperFormat(PaperFormat paperFormat) {
        this.paperFormat = paperFormat;
    }

    @Override
    public void show(Sheet sheet) {
    }
}

