/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.sheet;

import org.dbdoclet.unit.Length;

public class Bound {
    private Length top;
    private Length right;
    private Length bottom;
    private Length left;

    public Bound() {
        this(new Length(0), new Length(0), new Length(0), new Length(0));
    }

    public Bound(Length top, Length right, Length bottom, Length left) {
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
    }

    public Length getTop() {
        if (this.top == null) {
            this.top = new Length(0);
        }
        return this.top;
    }

    public void setTop(Length top) {
        this.top = top;
    }

    public Length getRight() {
        if (this.right == null) {
            this.right = new Length(0);
        }
        return this.right;
    }

    public void setRight(Length right) {
        this.right = right;
    }

    public Length getBottom() {
        if (this.bottom == null) {
            this.bottom = new Length(0);
        }
        return this.bottom;
    }

    public void setBottom(Length bottom) {
        this.bottom = bottom;
    }

    public Length getLeft() {
        if (this.left == null) {
            this.left = new Length(0);
        }
        return this.left;
    }

    public void setLeft(Length left) {
        this.left = left;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bottom == null ? 0 : this.bottom.hashCode());
        result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
        result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
        result = 31 * result + (this.top == null ? 0 : this.top.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Bound otherBound = (Bound)other;
        if (this.top == null && otherBound.top != null) {
            return false;
        }
        if (!this.top.equals(otherBound.top)) {
            return false;
        }
        if (this.right == null && otherBound.right != null) {
            return false;
        }
        if (!this.right.equals(otherBound.right)) {
            return false;
        }
        if (this.bottom == null && otherBound.bottom != null) {
            return false;
        }
        if (!this.bottom.equals(otherBound.bottom)) {
            return false;
        }
        if (this.left == null && otherBound.left != null) {
            return false;
        }
        return this.left.equals(otherBound.left);
    }

    public String toString() {
        return "Bound [top=" + this.top + ", right=" + this.right + ", bottom=" + this.bottom + ", left=" + this.left + "]";
    }

    protected static Length[] parse(String buffer) {
        if (buffer == null) {
            return new Length[0];
        }
        String[] tokens = buffer.split("\\s+");
        if (tokens == null) {
            return new Length[0];
        }
        Length[] list = new Length[tokens.length];
        int index = 0;
        for (String token : tokens) {
            list[index++] = Length.valueOf(token);
        }
        return list;
    }

    public String toNormalizedString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getTop().toNormalizedString());
        buffer.append(' ');
        buffer.append(this.getRight().toNormalizedString());
        buffer.append(' ');
        buffer.append(this.getBottom().toNormalizedString());
        buffer.append(' ');
        buffer.append(this.getLeft().toNormalizedString());
        return buffer.toString();
    }
}

