/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.sheet;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.dbdoclet.format.Alignment;
import org.dbdoclet.format.Display;
import org.dbdoclet.format.FontWeight;
import org.dbdoclet.jive.JiveConstants;
import org.dbdoclet.jive.sheet.Line;
import org.dbdoclet.jive.sheet.Lines;
import org.dbdoclet.jive.sheet.Margin;
import org.dbdoclet.jive.sheet.Padding;
import org.dbdoclet.jive.sheet.Part;
import org.dbdoclet.jive.sheet.Sheet;
import org.dbdoclet.unit.Length;
import org.w3c.dom.Element;

public abstract class AbstractPart
implements Part {
    protected Rectangle2D.Double boundingBox;
    protected Rectangle2D.Double paddingBox;
    protected Rectangle2D.Double contentBox;
    private ArrayList<Part> children;
    private Color foreground;
    private Display display;
    private Part parent;
    protected Alignment alignment;
    protected Font font;
    protected String id;
    protected int index = -1;
    protected Margin margin = new Margin();
    protected Padding padding = new Padding();
    protected ResourceBundle res;
    protected boolean selected;
    protected final Sheet sheet;

    public AbstractPart(Sheet sheet) {
        if (sheet == null) {
            throw new IllegalArgumentException("The argument sheet must not be null!");
        }
        this.sheet = sheet;
        this.res = sheet.getResourceBundle();
        this.children = new ArrayList();
    }

    @Override
    public void appendChild(Part part) {
        if (part != null) {
            this.children.add(part);
            part.setParent(this);
        }
        this.updateChildren();
    }

    @Override
    public int computeFontHeight(Graphics2D g2d, Font font) {
        FontMetrics fm = g2d.getFontMetrics(font);
        return fm.getHeight();
    }

    @Override
    public void copyProperties(Part to) {
        to.setMargin(this.getMargin().deepCopy());
        to.setPadding(this.getPadding().deepCopy());
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public Rectangle2D.Double getBoundingBox() {
        return this.getMarginBox();
    }

    public Part getChild(int index) {
        this.updateChildren();
        if (index >= 0 && index < this.children.size()) {
            return this.children.get(index);
        }
        return null;
    }

    public Part getChildById(String id) {
        if (this.children == null || this.children.size() == 0) {
            return null;
        }
        for (Part child : this.children) {
            if (child == null || child.getId() == null || !child.getId().equals(id)) continue;
            return child;
        }
        return null;
    }

    @Override
    public ArrayList<Part> getChildren() {
        this.updateChildren();
        return this.children;
    }

    public Rectangle2D.Double getContentBox() {
        if (this.contentBox == null) {
            this.contentBox = new Rectangle2D.Double();
        }
        return this.contentBox;
    }

    @Override
    public Rectangle2D.Double getCopyOfContentBox() {
        Rectangle2D.Double copy = new Rectangle2D.Double();
        if (this.contentBox == null) {
            this.updateBoxes();
        }
        copy.x = this.contentBox.x;
        copy.y = this.contentBox.y;
        copy.width = this.contentBox.width;
        copy.height = this.contentBox.height;
        return copy;
    }

    public Display getDisplay() {
        if (this.display == null) {
            return Display.INLINE;
        }
        return this.display;
    }

    public Part getFirstChild() {
        if (this.children == null || this.children.size() == 0) {
            return null;
        }
        Part part = this.children.get(0);
        part.setIndex(0);
        return part;
    }

    public Font getFont() {
        return this.font;
    }

    public Color getForeground() {
        return this.foreground;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public Part getLastChild() {
        if (this.children == null || this.children.size() == 0) {
            return null;
        }
        Part part = this.children.get(this.children.size() - 1);
        part.setIndex(this.children.size() - 1);
        return part;
    }

    @Override
    public Margin getMargin() {
        return this.margin.deepCopy();
    }

    @Override
    public Rectangle2D.Double getMarginBox() {
        if (this.boundingBox == null) {
            this.boundingBox = new Rectangle2D.Double();
        }
        return this.boundingBox;
    }

    @Override
    public double getNormalizedHeight() {
        double height = this.getMargin().getTop().toMillimeter();
        height += this.getPadding().getTop().toMillimeter();
        for (Part staff : this.children) {
            height += staff.getNormalizedHeight();
        }
        height += this.getPadding().getBottom().toMillimeter();
        return height += this.getMargin().getBottom().toMillimeter();
    }

    @Override
    public Padding getPadding() {
        return this.padding.deepCopy();
    }

    public Rectangle2D.Double getPaddingBox() {
        if (this.paddingBox == null) {
            this.paddingBox = new Rectangle2D.Double();
        }
        return this.paddingBox;
    }

    @Override
    public Part getParent() {
        return this.parent;
    }

    public ResourceBundle getResourceBundle() {
        return this.res;
    }

    @Override
    public Sheet getSheet() {
        return this.sheet;
    }

    @Override
    public double getSpaceAfter() {
        return this.margin.getBottom().toMillimeter() + this.padding.getBottom().toMillimeter();
    }

    @Override
    public double getSpaceBefore() {
        return this.margin.getTop().toMillimeter() + this.padding.getTop().toMillimeter();
    }

    @Override
    public String getTagName() {
        return this.getClass().getSimpleName().toLowerCase();
    }

    @Override
    public void insertChild(int index, Part part) {
        if (part == null) {
            throw new IllegalArgumentException("Argument part must not be null!");
        }
        if (index >= 0 && index < this.children.size()) {
            this.children.add(index, part);
            part.setParent(this);
        } else {
            this.children.add(part);
            part.setParent(this);
        }
        this.updateChildren();
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    public void removeAll() {
        this.children.clear();
    }

    public Part removeChild(int index) {
        Part child = this.children.remove(index);
        this.updateChildren();
        return child;
    }

    @Override
    public boolean removeChild(Part part) {
        boolean rc = this.children.remove(part);
        this.updateChildren();
        return rc;
    }

    @Override
    public int rzoom(double value) {
        return this.sheet.rzoom(value);
    }

    @Override
    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    @Override
    public void setBoundingBox(Rectangle2D.Double boundingBox) {
        this.boundingBox = new Rectangle2D.Double();
        this.boundingBox.x = boundingBox.x;
        this.boundingBox.y = boundingBox.y;
        this.boundingBox.width = boundingBox.width;
        this.boundingBox.height = boundingBox.height;
        this.updateBoxes();
    }

    @Override
    public void setDisplay(Display display) {
        this.display = display;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public void setFontSize(Length fontSize) {
        if (this.font != null) {
            this.font = this.font.deriveFont((float)fontSize.toPoint());
        }
    }

    @Override
    public void setFontWeight(FontWeight fontWeight) {
        if (this.font != null && !this.font.isBold() && fontWeight == FontWeight.BOLD) {
            this.font = this.font.deriveFont(1);
        }
    }

    @Override
    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void setMargin(Margin margin) {
        this.margin = margin;
        this.updateBoxes();
    }

    @Override
    public void setMarginBottom(Length marginBottom) {
        this.margin.setBottom(marginBottom);
        this.updateBoxes();
    }

    @Override
    public void setMarginLeft(Length marginLeft) {
        this.margin.setLeft(marginLeft);
        this.updateBoxes();
    }

    @Override
    public void setMarginRight(Length marginRight) {
        this.margin.setRight(marginRight);
        this.updateBoxes();
    }

    @Override
    public void setMarginTop(Length marginTop) {
        this.margin.setTop(marginTop);
        this.updateBoxes();
    }

    @Override
    public void setPadding(Padding padding) {
        this.padding = padding;
        this.updateBoxes();
    }

    @Override
    public void setParent(Part parent) {
        this.parent = parent;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getIndex() + ")";
    }

    public int unzoom(double value) {
        return this.sheet.unzoom(value);
    }

    public void updateBoxes() {
        if (this.boundingBox == null) {
            this.boundingBox = new Rectangle2D.Double();
        }
        if (this.paddingBox == null) {
            this.paddingBox = new Rectangle2D.Double();
        }
        if (this.contentBox == null) {
            this.contentBox = new Rectangle2D.Double();
        }
        Margin margin = this.getMargin();
        this.paddingBox.x = this.boundingBox.x + margin.getLeft().toMillimeter();
        this.paddingBox.y = this.boundingBox.y + margin.getTop().toMillimeter();
        this.paddingBox.width = this.boundingBox.width - (margin.getLeft().toMillimeter() + margin.getRight().toMillimeter());
        this.paddingBox.height = this.boundingBox.height - (margin.getTop().toMillimeter() + margin.getBottom().toMillimeter());
        Padding padding = this.getPadding();
        this.contentBox.x = this.paddingBox.x + padding.getLeft().toMillimeter();
        this.contentBox.y = this.paddingBox.y + padding.getTop().toMillimeter();
        this.contentBox.width = this.paddingBox.width - (padding.getLeft().toMillimeter() + padding.getRight().toMillimeter());
        this.contentBox.height = this.paddingBox.height - (padding.getTop().toMillimeter() + padding.getBottom().toMillimeter());
    }

    @Override
    public void writeElement(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("The argument element must not be null!");
        }
        element.setAttribute("margin", this.getMargin().toNormalizedString());
        element.setAttribute("padding", this.getPadding().toNormalizedString());
        String id = this.getId();
        if (id != null && id.trim().length() > 0) {
            element.setAttribute("id", id.trim());
        }
    }

    @Override
    public double zoom(double value) {
        return this.sheet.zoom(value);
    }

    public Lines zoom(Lines lines) {
        Lines zoomed = new Lines();
        for (Line line : lines.getList()) {
            zoomed.add(this.zoom(line));
        }
        return zoomed;
    }

    private void updateChildren() {
        int index = 0;
        for (Part part : this.children) {
            part.setIndex(index++);
        }
    }

    private Line zoom(Line line) {
        Line zoomed = new Line(this.zoom(line.getP1()), this.zoom(line.getP2()));
        return zoomed;
    }

    private Point2D.Double zoom(Point2D.Double p) {
        Point2D.Double zoomed = new Point2D.Double(this.rzoom(p.getX()), this.rzoom(p.getY()));
        return zoomed;
    }

    protected void afterPaintPart(Graphics2D g2d) {
        if (this.sheet.isVisibleSpaceEnabled()) {
            Rectangle2D.Double bb = this.getMarginBox();
            g2d.setPaint(Color.red);
            g2d.setStroke(new BasicStroke(1.0f));
            Rectangle zbb = this.sheet.rzoom(bb);
            g2d.drawRect(zbb.x, zbb.y, zbb.width, zbb.height);
            bb = this.getPaddingBox();
            g2d.setPaint(Color.green);
            g2d.setStroke(new BasicStroke(1.0f));
            zbb = this.sheet.rzoom(bb);
            g2d.drawRect(zbb.x, zbb.y, zbb.width, zbb.height);
            bb = this.getContentBox();
            g2d.setPaint(JiveConstants.COLOUR_BLUE_GRAY_1);
            g2d.setStroke(new BasicStroke(1.0f));
            zbb = this.sheet.rzoom(bb);
            g2d.drawRect(zbb.x, zbb.y, zbb.width, zbb.height);
        }
    }

    protected void beforePaintPart(Graphics2D g2d) {
        if (this.isSelected()) {
            Rectangle bb = this.sheet.rzoom(this.getMarginBox());
            g2d.setPaint(JiveConstants.COLOUR_BEIGE);
            g2d.fillRect(bb.x, bb.y, bb.width, bb.height);
        }
    }

    protected int computeStringWidth(Graphics2D g2d, Font font, String content) {
        FontMetrics fm = g2d.getFontMetrics(font);
        return fm.stringWidth(content);
    }

    protected void fillCopy(AbstractPart copy) {
        copy.setMargin(this.getMargin().deepCopy());
        copy.setPadding(this.getPadding().deepCopy());
        copy.setId(this.getId());
        copy.setIndex(this.getIndex());
        for (Part child : this.getChildren()) {
            copy.appendChild(child.deepCopy(copy.getSheet()));
        }
    }

    protected Rectangle2D.Double getCopyOfBoundingBox() {
        Rectangle2D.Double copy = new Rectangle2D.Double();
        copy.x = this.boundingBox.x;
        copy.y = this.boundingBox.y;
        copy.width = this.boundingBox.width;
        copy.height = this.boundingBox.height;
        return copy;
    }

    protected int getNumOfChildren() {
        return this.children.size();
    }

    protected void paintContainer(Graphics2D g2d) {
        double y = 0.0;
        Rectangle2D.Double pbb = this.getBoundingBox();
        pbb.height = 0.0;
        pbb.height = this.getMargin().getTop().toMillimeter() + this.getPadding().getTop().toMillimeter();
        for (Part child : this.getChildren()) {
            Rectangle2D.Double bb = this.getCopyOfContentBox();
            bb.height = 0.0;
            bb.y += y;
            child.setBoundingBox(bb);
            child.paintPart(g2d);
            pbb.height += (y += child.getNormalizedHeight());
        }
        pbb.height += this.getPadding().getBottom().toMillimeter() + this.getMargin().getBottom().toMillimeter();
        this.updateBoxes();
    }

    protected void paintLayoutInfo(Graphics2D g2d, Rectangle bb, Color color, String text) {
        g2d.setPaint(color);
        g2d.drawRect(bb.x, bb.y, bb.width, bb.height);
        g2d.drawString(text, bb.x, bb.y - 2);
    }

    protected Point zoom(Point p) {
        Point zoomed = new Point(this.rzoom(p.getX()), this.rzoom(p.getY()));
        return zoomed;
    }

    @Override
    public void setFontFamily(String value) {
    }
}

