/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.monitor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.jive.monitor.ModelItem;
import org.dbdoclet.jive.monitor.MonitorModel;

class ServerThread
extends Thread {
    private static Log logger = LogFactory.getLog(ServerThread.class);
    private boolean halt = false;
    private final MonitorModel model;
    private final ServerSocket serverSocket;

    public ServerThread(MonitorModel model) throws IOException {
        this.model = model;
        this.serverSocket = new ServerSocket(0);
    }

    public int getLocalPort() {
        if (this.serverSocket == null) {
            return 0;
        }
        return this.serverSocket.getLocalPort();
    }

    @Override
    public void run() {
        while (!this.halt) {
            try {
                logger.debug((Object)"accept()");
                Socket socket = this.serverSocket.accept();
                logger.debug((Object)"getInputStream()");
                InputStream inputStream = socket.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                logger.debug((Object)"readLine()");
                String data = reader.readLine();
                while (data != null) {
                    String key;
                    ModelItem item;
                    String[] tokens;
                    logger.debug((Object)("data=" + data));
                    logger.debug((Object)"readLine()");
                    data = reader.readLine();
                    if (data == null || (tokens = data.split("\\s*,\\s*")).length != 2 || (item = this.model.findItem(key = tokens[0].trim())) == null) continue;
                    item.setValue(tokens[1].trim());
                    this.model.update();
                }
                logger.debug((Object)"reader.close()");
                reader.close();
            }
            catch (Throwable oops) {
                logger.fatal((Object)"ServerSocket/", oops);
            }
        }
        try {
            this.serverSocket.close();
        }
        catch (Throwable oops) {
            logger.fatal((Object)"ServerSocket/", oops);
        }
    }

    public void halt() {
        this.halt = true;
    }
}

