/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.monitor;

import org.dbdoclet.jive.monitor.ModelItem;

public class ResourceItem
extends ModelItem {
    private Boolean hasChanged;
    private final String key;
    private final String label;
    private String value;

    public ResourceItem(String key, String label) {
        if (key == null) {
            throw new IllegalArgumentException("The argument key must not be null!");
        }
        this.key = key;
        this.label = label;
    }

    public boolean equals(Object other) {
        return this.equals((ResourceItem)other);
    }

    public boolean equals(ResourceItem other) {
        return this.key.equals(other.getKey());
    }

    @Override
    public String getName() {
        return " " + this.label;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Boolean hasChanged() {
        return this.hasChanged;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    private String getKey() {
        return this.key;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            return;
        }
        Integer length = new Integer(value.toString());
        this.value = this.createByteUnit(length.intValue());
    }
}

