/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.monitor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import org.dbdoclet.jive.Fill;
import org.dbdoclet.jive.monitor.IconTableCellRenderer;
import org.dbdoclet.jive.monitor.MonitorModel;
import org.dbdoclet.jive.monitor.RefreshThread;
import org.dbdoclet.jive.monitor.RightTableCellRenderer;
import org.dbdoclet.jive.monitor.ServerThread;
import org.dbdoclet.jive.widget.GridPanel;

public class MonitorPanel
extends GridPanel {
    private static final long serialVersionUID = 1L;
    private static final int COLUMN_NAME_INDEX = 0;
    private static final int COLUMN_VALUE_INDEX = 1;
    private static final int COLUMN_ICON_INDEX = 2;
    private JTable table;
    private MonitorModel model;
    private final RefreshThread refresh;
    private ServerThread server;

    public MonitorPanel() {
        this.createGui();
        this.refresh = new RefreshThread(this.model);
        this.refresh.start();
        try {
            this.server = new ServerThread(this.model);
            this.server.start();
        }
        catch (IOException oops) {
            oops.printStackTrace();
        }
    }

    public int getLocalPort() {
        return this.server.getLocalPort();
    }

    protected void finalize() throws Throwable {
        this.refresh.halt();
        super.finalize();
    }

    private void createGui() {
        this.table = new JTable();
        this.table.setBorder(BorderFactory.createLineBorder(Color.black));
        this.model = new MonitorModel();
        this.table.setModel(this.model);
        this.table.setFont(new Font("monospace", 0, 11));
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(200);
        columnModel.getColumn(1).setPreferredWidth(100);
        columnModel.getColumn(1).setCellRenderer(new RightTableCellRenderer());
        columnModel.getColumn(2).setPreferredWidth(10);
        columnModel.getColumn(2).setCellRenderer(new IconTableCellRenderer());
        this.addComponent((JComponent)this.table, Fill.BOTH);
        this.setPreferredSize(new Dimension(300, 100));
    }

    public void clear() {
        this.model.clear();
    }

    public void addFile(File file) {
        this.model.addFile(file);
    }

    public void addResource(String key, String label) {
        this.model.addResource(key, label);
    }
}

