/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.monitor;

import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.dbdoclet.jive.monitor.FileItem;
import org.dbdoclet.jive.monitor.ModelItem;
import org.dbdoclet.jive.monitor.ResourceItem;

public class MonitorModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private Hashtable<String, ModelItem> dataMap = new Hashtable();
    private Vector<ModelItem> dataList = new Vector();

    public void addFile(File file) {
        FileItem item = new FileItem(file);
        this.dataMap.put(file.getAbsolutePath(), item);
        this.dataList.add(item);
    }

    public void addResource(String key, String label) {
        ResourceItem item = new ResourceItem(key, label);
        this.dataMap.put(key, item);
        this.dataList.add(item);
    }

    public void clear() {
        this.dataMap.clear();
        this.dataList.clear();
    }

    public ModelItem findItem(String key) {
        return this.dataMap.get(key);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Monitor";
            }
            case 2: {
                return "Icon";
            }
        }
        return "";
    }

    @Override
    public int getRowCount() {
        return this.dataList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.dataList.size()) {
            return null;
        }
        ModelItem item = this.dataList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return item.getName();
            }
            case 1: {
                return item.getValue();
            }
            case 2: {
                return item.hasChanged();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void update() {
        this.fireTableDataChanged();
    }
}

