/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.monitor;

import java.io.File;
import java.util.ArrayList;
import org.dbdoclet.jive.monitor.ModelItem;

public class FileItem
extends ModelItem {
    private static final int RING_BUFFER_SIZE = 10;
    private File file;
    private String[] history;
    private int historyIndex = 0;

    public FileItem(File file) {
        this.file = file;
        this.history = new String[10];
    }

    public boolean equals(FileItem other) {
        return this.file.equals(other.getFile());
    }

    public boolean equals(Object other) {
        return this.equals((FileItem)other);
    }

    @Override
    public String getName() {
        return String.format(" %s", this.file.getName());
    }

    @Override
    public String getValue() {
        long length = this.file.length();
        String value = this.createByteUnit(length);
        this.addHistory(value);
        return value;
    }

    @Override
    public Boolean hasChanged() {
        ArrayList<String> uniqueList = new ArrayList<String>();
        for (String entry : this.history) {
            if (uniqueList.contains(entry)) continue;
            uniqueList.add(entry);
        }
        if (uniqueList.size() > 3) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        if (this.file == null) {
            return "";
        }
        return this.file.getName();
    }

    private void addHistory(String value) {
        if (this.historyIndex >= 10) {
            this.historyIndex = 0;
        }
        this.history[this.historyIndex++] = value;
    }

    private File getFile() {
        return this.file;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof File) {
            this.file = (File)value;
        }
    }
}

