/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.model;

import java.util.ArrayList;
import java.util.Locale;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.dbdoclet.unit.Length;

public class SpinnerDistanceModel
implements SpinnerModel {
    private Length length;
    private ArrayList<ChangeListener> listenerList;
    private final Locale locale;
    private boolean excludePercent = true;

    public SpinnerDistanceModel(Locale locale) {
        this.locale = locale;
        this.length = new Length();
        this.listenerList = new ArrayList();
    }

    public void setExcludePercent(boolean excludePercent) {
        this.excludePercent = excludePercent;
        if (this.length != null) {
            this.length.setExcludePercent(excludePercent);
        }
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    @Override
    public Object getNextValue() {
        if (this.length != null) {
            this.length.incrDistance(0.1f);
        }
        return this.length;
    }

    @Override
    public Object getPreviousValue() {
        if (this.length != null) {
            this.length.decrDistance(0.1f);
        }
        return this.length;
    }

    @Override
    public Object getValue() {
        return this.length;
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.listenerList.remove(listener);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.length = new Length();
            this.length.setExcludePercent(this.excludePercent);
            this.length.setLocale(this.locale);
        } else if (value instanceof String) {
            this.length.setLocalizedValue((String)value);
        } else if (value instanceof Length) {
            this.length = (Length)value;
            this.length.setExcludePercent(this.excludePercent);
            this.length.setLocale(this.locale);
        } else {
            throw new IllegalArgumentException("Invalid type " + value.getClass().getName() + " for SpinnerDistanceModel. Only String and Distance is allowed.");
        }
        this.fireChangeEvent();
    }

    private void fireChangeEvent() {
        for (ChangeListener listener : this.listenerList) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }
}

