/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.io.FileSet;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.model.LabelItem;
import org.dbdoclet.service.ResourceServices;

public class PathListModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(PathListModel.class);
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_PATH = 1;
    public static final int COLUMN_STATUS = 2;
    public static final int COLUMN_FILTER_TYPE = 3;
    public static final int COLUMN_CASE_SENSITIVE = 4;
    public static final int COLUMN_FILTER = 5;
    public static final int COLUMN_COUNT = 6;
    private final ArrayList<FileSet> data;
    private final JiveFactory widgetMap;
    private final ResourceBundle res;
    private File cwd;

    public PathListModel(JiveFactory widgetMap) {
        if (widgetMap == null) {
            throw new IllegalArgumentException("The argument widgetMap must not be null!");
        }
        this.widgetMap = widgetMap;
        this.res = widgetMap.getResourceBundle();
        this.data = new ArrayList();
        this.cwd = new File(".");
    }

    public void setWorkingDir(File cwd) {
        if (cwd == null) {
            throw new IllegalArgumentException("The argument cwd may not be null!");
        }
        this.cwd = cwd;
    }

    public ArrayList<FileSet> getFileSets() {
        if (this.data == null) {
            throw new IllegalStateException("The field data may not be null!");
        }
        return this.data;
    }

    public void changed() {
        this.fireTableStructureChanged();
        if (this.widgetMap != null) {
            this.widgetMap.enableSaveWidgets();
        }
    }

    public void rowChanged(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.data.size()) {
            return;
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public synchronized void clear() {
        if (this.data == null) {
            throw new IllegalStateException("The field data may not be null!");
        }
        this.data.clear();
        this.fireTableStructureChanged();
        if (this.widgetMap != null) {
            this.widgetMap.enableSaveWidgets();
        }
    }

    public boolean contains(String path) throws IOException {
        FileSet fileset = new FileSet(this.cwd, new File(path));
        return this.contains(fileset);
    }

    public boolean contains(FileSet fileset) {
        if (this.data == null) {
            throw new IllegalStateException("The field data may not be null!");
        }
        if (fileset == null) {
            throw new IllegalArgumentException("The argument fileset may not be null!");
        }
        return this.data.contains(fileset);
    }

    public int size() {
        if (this.data == null) {
            throw new IllegalStateException("The field data may not be null!");
        }
        return this.data.size();
    }

    public FileSet getEntry(int index) {
        if (this.data == null) {
            throw new IllegalStateException("The field data may not be null!");
        }
        if (index < 0) {
            throw new IllegalArgumentException("The argument index may not be less than 0!");
        }
        return this.data.get(index);
    }

    public synchronized void addEntry(String path) {
        if (this.data == null) {
            throw new IllegalStateException("The field data may not be null!");
        }
        if (path == null) {
            throw new IllegalArgumentException("The argument path may not be null!");
        }
        logger.debug((Object)("cwd=" + this.cwd));
        logger.debug((Object)("path=" + path));
        this.addEntry(new FileSet(this.cwd, new File(path)));
    }

    public synchronized void addEntry(FileSet fileset) {
        this.addEntry(fileset, -1);
    }

    public synchronized void addEntry(FileSet fileset, int pos) {
        if (this.data == null) {
            throw new IllegalStateException("The field data may not be null!");
        }
        if (fileset == null) {
            throw new IllegalArgumentException("The argument fileset may not be null!");
        }
        if (pos > -1 && pos < this.data.size()) {
            this.data.add(pos, fileset);
        } else {
            this.data.add(fileset);
        }
        this.validate();
        int row = this.data.size() - 1;
        this.fireTableRowsInserted(row, row);
        if (this.widgetMap != null) {
            this.widgetMap.enableSaveWidgets();
        }
    }

    public synchronized void removeEntry(int selectedId) {
        if (this.data == null) {
            throw new IllegalStateException("The field data may not be null!");
        }
        for (int i = 0; i < this.data.size(); ++i) {
            FileSet entry = this.data.get(i);
            Integer id = entry.getId();
            if (id == null || id != selectedId) continue;
            this.data.remove(i);
            this.fireTableStructureChanged();
            break;
        }
        if (this.widgetMap != null) {
            this.widgetMap.enableSaveWidgets();
        }
        this.validate();
    }

    public synchronized void removeEntry(FileSet fileset) {
        if (this.data == null) {
            throw new IllegalStateException("The field data may not be null!");
        }
        for (int i = 0; i < this.data.size(); ++i) {
            FileSet entry = this.data.get(i);
            if (!fileset.equals(entry)) continue;
            this.data.remove(i);
            this.fireTableStructureChanged();
            break;
        }
        if (this.widgetMap != null) {
            this.widgetMap.enableSaveWidgets();
        }
        this.validate();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public String getColumnName(int column) {
        if (column < 0 || column >= 6) {
            throw new IllegalArgumentException("Illegal value " + column + " for argument column!");
        }
        switch (column) {
            case 0: {
                return ResourceServices.getString(this.res, "C_SEQUENCE");
            }
            case 1: {
                return ResourceServices.getString(this.res, "C_PATH");
            }
            case 2: {
                return ResourceServices.getString(this.res, "C_STATUS");
            }
            case 4: {
                return ResourceServices.getString(this.res, "C_CASE_SENSITIVE");
            }
            case 3: {
                return ResourceServices.getString(this.res, "C_FILTER_TYPE");
            }
            case 5: {
                return ResourceServices.getString(this.res, "C_FILTER");
            }
        }
        return "???";
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (column < 0 || column >= 6) {
            throw new IllegalArgumentException("Illegal value " + column + " for argument column!");
        }
        switch (column) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return File.class;
            }
            case 4: {
                return Boolean.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return LabelItem.class;
            }
            case 5: {
                return String.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (column < 0 || column >= 6) {
            throw new IllegalArgumentException("Illegal value " + column + " for argument column!");
        }
        if (row < 0) {
            throw new IllegalArgumentException("Illegal value " + row + " for argument row!");
        }
        FileSet fileset = this.getEntry(row);
        switch (column) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: 
            case 4: 
            case 5: {
                return fileset.isDirectory();
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object obj, int row, int column) {
        if (this.data == null) {
            throw new IllegalStateException("The field data may not be null!");
        }
        if (obj == null) {
            throw new IllegalArgumentException("The argument obj may not be null!");
        }
        if (row < 0 || row >= this.data.size()) {
            throw new IllegalArgumentException("The argument row may not be null!");
        }
        if (column < 0 || column >= 6) {
            throw new IllegalArgumentException("Illegal value " + column + " for argument column!");
        }
        FileSet entry = this.data.get(row);
        Integer id = entry.getId();
        switch (column) {
            case 0: {
                if (obj instanceof Integer) {
                    int pos = (Integer)obj;
                    if (pos < 1 || pos > this.data.size()) {
                        return;
                    }
                    this.removeEntry(id);
                    this.addEntry(entry, pos - 1);
                    this.validate();
                    break;
                }
                throw new IllegalArgumentException("Invalid id type " + obj.getClass().getName() + ".");
            }
            case 1: {
                if (obj instanceof String) {
                    entry.setPath(new File((String)obj));
                    break;
                }
                if (obj instanceof File) {
                    entry.setPath((File)obj);
                    break;
                }
                throw new IllegalArgumentException("Invalid path type " + obj.getClass().getName() + ".");
            }
            case 4: {
                if (!(obj instanceof Boolean)) break;
                entry.setCaseSensitive((Boolean)obj);
                break;
            }
            case 3: {
                logger.info((Object)("setValueAt: Filter type = " + obj.getClass().getName()));
                if (!(obj instanceof LabelItem)) break;
                LabelItem item = (LabelItem)obj;
                Integer type = (Integer)item.getValue();
                entry.setFilterType(type);
                break;
            }
            case 5: {
                if (!(obj instanceof String)) break;
                String filter = (String)obj;
                int filterType = entry.getFilterType();
                if (filterType != 0 && filter.trim().length() <= 0) break;
                entry.setFilter(filter);
            }
        }
        this.fireTableRowsUpdated(row, row);
        if (this.widgetMap != null) {
            this.widgetMap.enableSaveWidgets();
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        FileSet entry = this.data.get(row);
        switch (column) {
            case 0: {
                return entry.getId();
            }
            case 1: {
                return entry.getPath();
            }
            case 2: {
                return String.valueOf(entry.getStatus());
            }
            case 4: {
                return entry.getCaseSensitive();
            }
            case 3: {
                return this.getFilterTypeLabel(entry);
            }
            case 5: {
                return entry.getFilter();
            }
        }
        return "???";
    }

    private String getFilterTypeLabel(FileSet entry) {
        switch (entry.getFilterType()) {
            case 0: {
                return ResourceServices.getString(this.res, "C_NO_FILTER");
            }
            case 1: {
                return ResourceServices.getString(this.res, "C_INCLUDE_FILES");
            }
            case 2: {
                return ResourceServices.getString(this.res, "C_EXCLUDE_FILES");
            }
            case 3: {
                return ResourceServices.getString(this.res, "C_INCLUDE_DIRECTORIES");
            }
            case 4: {
                return ResourceServices.getString(this.res, "C_EXCLUDE_DIRECTORIES");
            }
            case 5: {
                return ResourceServices.getString(this.res, "C_INCLUDE_PACKAGES");
            }
            case 6: {
                return ResourceServices.getString(this.res, "C_EXCLUDE_PACKAGES");
            }
        }
        return ResourceServices.getString(this.res, "C_UNKNOWN_FILTER_TYPE");
    }

    private void validate() {
        if (this.data == null) {
            throw new IllegalStateException("The field data may not be null!");
        }
        for (int i = 0; i < this.data.size(); ++i) {
            FileSet entry = this.data.get(i);
            entry.setId(i + 1);
            try {
                this.fireTableCellUpdated(i, 0);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public ArrayList<FileSet> findEntry(File path) {
        ArrayList<FileSet> hits = new ArrayList<FileSet>();
        for (int i = 0; i < this.data.size(); ++i) {
            if (!path.equals(this.data.get(i).getQualifiedPath())) continue;
            hits.add(this.data.get(i));
        }
        if (hits.size() == 0) {
            return null;
        }
        return hits;
    }
}

