/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.model;

import java.io.File;

public class FileItem {
    private String label;
    private File file;

    public FileItem(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter file is null!");
        }
        this.file = file;
        this.label = file.getName();
        if (this.label.matches(".+\\.xsl(?i)")) {
            this.label = this.label.substring(0, this.label.length() - 4);
            this.label = this.label.replace('_', ' ');
        }
    }

    public String getLabel() {
        return this.label;
    }

    protected void setLabel(String label) {
        this.label = label;
    }

    public File getFile() {
        return this.file;
    }

    protected void setFile(File file) {
        this.file = file;
    }

    public boolean equals(Object obj) {
        FileItem item;
        File file;
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            String file2 = (String)obj;
            return file2.equals(this.file);
        }
        return obj instanceof FileItem && (file = (item = (FileItem)obj).getFile()).equals(this.file);
    }

    public int hashCode() {
        int hashCode = this.file.hashCode();
        return hashCode;
    }

    public String toString() {
        return this.label;
    }
}

