/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.fo;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.dbdoclet.Identifier;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.fo.FoAttributePanel;
import org.dbdoclet.jive.fo.FoAttributeSet;
import org.dbdoclet.jive.fo.FoAttributeSetDialog;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.service.ResourceServices;
import org.dbdoclet.unit.Length;

public class LinePanel
extends FoAttributePanel
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private JCheckBox lineEnabledCheckBox;
    private JComboBox<String> wrapOptionComboBox;
    private JComboBox<String> textAlignComboBox;
    private JSpinner widthSpinner;
    private JSpinner lineHeightSpinner;
    private ResourceBundle res;
    private JiveFactory jf;
    private final FoAttributeSet attributeSet;
    private GridPanel paramPanel;

    public LinePanel(FoAttributeSetDialog dialog, FoAttributeSet attributeSet) {
        this.attributeSet = attributeSet;
        this.createGui();
        this.lineEnabledCheckBox.setSelected(attributeSet.isLineEnabled());
    }

    private void createGui() {
        this.jf = JiveFactory.getInstance();
        this.res = this.jf.getResourceBundle();
        this.addSeparator(4, ResourceServices.getString(this.res, "C_LINE"));
        this.lineEnabledCheckBox = this.jf.createCheckBox(null, ResourceServices.getString(this.res, "C_ACTIVATE"));
        this.lineEnabledCheckBox.setSelected(false);
        this.lineEnabledCheckBox.setActionCommand("line-enabled");
        this.lineEnabledCheckBox.addActionListener(this);
        this.addComponent(this.lineEnabledCheckBox);
        this.incrRow();
        this.paramPanel = new GridPanel();
        this.wrapOptionComboBox = this.jf.createComboBox(new Identifier("fo.wrap.option"), new String[]{"inherit", "wrap", "no-wrap"});
        this.wrapOptionComboBox.setSelectedItem(this.attributeSet.getWrapOption());
        this.paramPanel.addLabeledComponent("wrap-option", this.wrapOptionComboBox);
        this.textAlignComboBox = this.jf.createComboBox(new Identifier("fo.text-align.option"), new String[]{"left", "right", "center", "justify", "start", "end", "inherit"});
        this.textAlignComboBox.setSelectedItem(this.attributeSet.getTextAlign());
        this.paramPanel.addLabeledComponent("text-align", this.textAlignComboBox);
        this.paramPanel.incrRow();
        this.widthSpinner = this.jf.createDistanceSpinner(new Identifier("width"), false);
        this.widthSpinner.setValue(Length.valueOf(this.attributeSet.getLineWidth(), false));
        this.widthSpinner.addChangeListener(this);
        this.paramPanel.addLabeledComponent("width", (JComponent)this.widthSpinner);
        this.lineHeightSpinner = this.jf.createDistanceSpinner(new Identifier("line-height"));
        this.lineHeightSpinner.setValue(Length.valueOf(this.attributeSet.getLineHeight(), false));
        this.lineHeightSpinner.addChangeListener(this);
        this.paramPanel.addLabeledComponent("line-height", (JComponent)this.lineHeightSpinner);
        this.paramPanel.setLock(this.attributeSet.isLineEnabled());
        this.addComponent(this.paramPanel);
        this.incrRow();
        this.addVerticalGlue();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        Object source = event.getSource();
        if (cmd == null) {
            return;
        }
        if (source != null && source == this.lineEnabledCheckBox) {
            this.attributeSet.setLineEnabled(this.lineEnabledCheckBox.isSelected());
            this.paramPanel.setLock(this.lineEnabledCheckBox.isSelected());
        }
        if (source != null && source == this.wrapOptionComboBox) {
            this.attributeSet.setWrapOption(this.wrapOptionComboBox.getSelectedItem().toString());
        }
        if (source != null && source == this.textAlignComboBox) {
            this.attributeSet.setTextAlign(this.textAlignComboBox.getSelectedItem().toString());
        }
    }

    public String getWrapOption() {
        return (String)this.wrapOptionComboBox.getSelectedItem();
    }

    public String getTextAlign() {
        return (String)this.textAlignComboBox.getSelectedItem();
    }

    public JSpinner getWidthSpinner() {
        return this.widthSpinner;
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        JComponent comp = (JComponent)event.getSource();
        this.attributeSet.setChanged(true);
        if (comp == this.widthSpinner) {
            this.attributeSet.setLineWidth(LinePanel.getDistance(this.widthSpinner));
        }
        if (comp == this.lineHeightSpinner) {
            this.attributeSet.setLineHeight(LinePanel.getDistance(this.lineHeightSpinner));
        }
    }
}

