/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.fo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.dbdoclet.Identifier;
import org.dbdoclet.jive.Anchor;
import org.dbdoclet.jive.Colspan;
import org.dbdoclet.jive.Fill;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.fo.FoAttributePanel;
import org.dbdoclet.jive.fo.FoAttributeSet;
import org.dbdoclet.jive.fo.FoAttributeSetDialog;
import org.dbdoclet.jive.model.LabelItem;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.service.ResourceServices;

public class FontPanel
extends FoAttributePanel
implements ActionListener,
ChangeListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private final FoAttributeSet attributeSet;
    private JButton fontColorButton;
    private JCheckBox fontEnabledCheckBox;
    private JList<String> fontFamilySelect;
    private String[] fontList;
    private GridPanel paramPanel;
    private JTextField fontSize;
    private JSlider fontSizeSlider;
    private JList<LabelItem> fontStyleSelect;
    private JiveFactory jf;
    private ResourceBundle res;
    private final FoAttributeSetDialog dialog;
    private JLabel label;
    private JButton backgroundColorButton;

    public FontPanel(FoAttributeSetDialog dialog, FoAttributeSet attributeSet) {
        this.dialog = dialog;
        this.attributeSet = attributeSet;
        this.createGui();
        this.fontFamilySelect.setSelectedValue(attributeSet.getFontFamily(), true);
        if (this.fontFamilySelect.isSelectionEmpty()) {
            this.fontFamilySelect.setSelectedValue("Times Roman", true);
        }
        this.fontEnabledCheckBox.setSelected(attributeSet.isFontEnabled());
    }

    public String getFontFamily() {
        return this.fontFamilySelect.getSelectedValue();
    }

    public int getFontStyle() {
        int style = 0;
        LabelItem item = this.fontStyleSelect.getSelectedValue();
        if (item != null) {
            style = (Integer)item.getValue();
        }
        return style;
    }

    public int getFontSize() {
        return this.fontSizeSlider.getValue();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Color color;
        String cmd = event.getActionCommand();
        Object source = event.getSource();
        if (cmd == null) {
            return;
        }
        if (cmd.equalsIgnoreCase("chooseColor")) {
            color = JColorChooser.showDialog(this, ResourceServices.getString(this.res, "C_COLOR"), this.attributeSet.getForeground());
            this.attributeSet.setChanged(true);
            this.attributeSet.setForeground(color);
            this.updateLabel();
        }
        if (cmd.equalsIgnoreCase("chooseBackgroundColor")) {
            color = JColorChooser.showDialog(this, ResourceServices.getString(this.res, "C_BACKGROUND_COLOR"), this.attributeSet.getBackground());
            this.attributeSet.setChanged(true);
            this.attributeSet.setBackground(color);
            this.updateLabel();
        }
        if (source != null && source == this.fontEnabledCheckBox) {
            this.attributeSet.setFontEnabled(this.fontEnabledCheckBox.isSelected());
            this.paramPanel.setLock(this.fontEnabledCheckBox.isSelected());
        }
    }

    public String[] getFontList() {
        if (this.fontList == null) {
            this.fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        }
        return this.fontList;
    }

    public void setFontList(String[] fontList) {
        this.fontList = fontList;
    }

    public void setFontSize(int size) {
        this.fontSize.setText(String.valueOf(size));
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        JComponent comp = (JComponent)event.getSource();
        this.attributeSet.setChanged(true);
        if (comp == this.fontSizeSlider) {
            this.fontSize.setText(String.valueOf(this.fontSizeSlider.getValue()));
            this.dialog.updateAttributeSet();
            if (this.label != null) {
                this.updateLabel();
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            this.dialog.updateAttributeSet();
            if (this.label != null) {
                this.updateLabel();
            }
        }
    }

    private void updateLabel() {
        this.label.setFont(this.attributeSet.getFont());
        this.label.setForeground(this.attributeSet.getForeground());
        this.label.setBackground(this.attributeSet.getBackground());
    }

    private JComponent createFontColorChooser() {
        this.fontColorButton = this.jf.createButton(null, ResourceServices.getString(this.res, "C_COLOR") + "...");
        this.fontColorButton.setActionCommand("chooseColor");
        this.fontColorButton.addActionListener(this);
        return this.fontColorButton;
    }

    private JComponent createBackgroundColorChooser() {
        this.backgroundColorButton = this.jf.createButton(null, ResourceServices.getString(this.res, "C_BACKGROUND_COLOR") + "...");
        this.backgroundColorButton.setActionCommand("chooseBackgroundColor");
        this.backgroundColorButton.addActionListener(this);
        return this.backgroundColorButton;
    }

    private JComponent createFontFamilyChooser() {
        GridPanel panel = new GridPanel();
        panel.addComponent(this.jf.createLabel(null, ResourceServices.getString(this.res, "C_FONT")));
        panel.incrRow();
        DefaultListModel<String> model = new DefaultListModel<String>();
        this.fontFamilySelect = this.jf.createList(null);
        this.fontFamilySelect.setModel(model);
        this.fontFamilySelect.addListSelectionListener(this);
        for (String fontName : this.getFontList()) {
            model.addElement(fontName);
        }
        JScrollPane scrollPane = new JScrollPane(this.fontFamilySelect);
        scrollPane.setPreferredSize(new Dimension(200, 210));
        panel.addComponent((JComponent)scrollPane, Anchor.CENTER, Fill.HORIZONTAL);
        return panel;
    }

    private JComponent createFontSizeChooser() {
        GridPanel panel = new GridPanel();
        JLabel fontSizeLabel = this.jf.createLabel(null, ResourceServices.getString(this.res, "C_FONT_SIZE"));
        panel.addComponent(fontSizeLabel);
        this.fontSizeSlider = new JSlider(0, 5, 129, this.attributeSet.getFontSize());
        this.fontSizeSlider.setMajorTickSpacing(10);
        this.fontSizeSlider.setMinorTickSpacing(1);
        this.fontSizeSlider.setPaintTicks(true);
        this.fontSizeSlider.setPaintLabels(false);
        panel.addComponent((JComponent)this.fontSizeSlider, Anchor.CENTER, Fill.HORIZONTAL);
        this.fontSizeSlider.addChangeListener(this);
        this.fontSize = this.jf.createTextField(new Identifier("font.size"), 4);
        this.fontSize.setHorizontalAlignment(4);
        this.fontSize.setText(String.valueOf(this.attributeSet.getFontSize()));
        this.fontSize.setEditable(false);
        panel.addComponent(this.fontSize);
        return panel;
    }

    private JComponent createFontStyleChooser() {
        GridPanel panel = new GridPanel();
        panel.addComponent(this.jf.createLabel(null, ResourceServices.getString(this.res, "C_STYLE")));
        panel.incrRow();
        DefaultListModel<LabelItem> model = new DefaultListModel<LabelItem>();
        this.fontStyleSelect = this.jf.createList(null);
        this.fontStyleSelect.setModel(model);
        this.fontStyleSelect.addListSelectionListener(this);
        model.addElement(new LabelItem(ResourceServices.getString(this.res, "C_REGULAR"), 0));
        model.addElement(new LabelItem(ResourceServices.getString(this.res, "C_ITALIC"), 2));
        model.addElement(new LabelItem(ResourceServices.getString(this.res, "C_BOLD"), 1));
        model.addElement(new LabelItem(ResourceServices.getString(this.res, "C_BOLD_ITALIC"), 3));
        JScrollPane scrollPane = new JScrollPane(this.fontStyleSelect);
        scrollPane.setPreferredSize(new Dimension(200, 210));
        panel.addComponent((JComponent)scrollPane, Anchor.CENTER, Fill.HORIZONTAL);
        switch (this.attributeSet.getFontStyle()) {
            case 1: {
                this.fontStyleSelect.setSelectedIndex(2);
                break;
            }
            case 2: {
                this.fontStyleSelect.setSelectedIndex(1);
                break;
            }
            case 3: {
                this.fontStyleSelect.setSelectedIndex(3);
                break;
            }
            default: {
                this.fontStyleSelect.setSelectedIndex(0);
            }
        }
        return panel;
    }

    private void createGui() {
        this.jf = JiveFactory.getInstance();
        this.res = this.jf.getResourceBundle();
        this.addSeparator(4, ResourceServices.getString(this.res, "C_FONT"));
        this.fontEnabledCheckBox = this.jf.createCheckBox(null, ResourceServices.getString(this.res, "C_ACTIVATE"));
        this.fontEnabledCheckBox.setSelected(false);
        this.fontEnabledCheckBox.setActionCommand("font-enabled");
        this.fontEnabledCheckBox.addActionListener(this);
        this.addComponent(this.fontEnabledCheckBox);
        this.incrRow();
        this.paramPanel = new GridPanel();
        this.addComponent(this.paramPanel);
        this.paramPanel.addComponent(this.createFontFamilyChooser(), Anchor.NORTHWEST, Fill.BOTH);
        this.paramPanel.addComponent(this.createFontStyleChooser(), Anchor.NORTHEAST, Fill.BOTH);
        this.paramPanel.incrRow();
        this.paramPanel.addComponent(this.createFontSizeChooser(), Colspan.CS_2, Anchor.CENTER, Fill.HORIZONTAL);
        this.paramPanel.incrRow();
        GridPanel colorPanel = new GridPanel();
        this.paramPanel.addComponent((JComponent)colorPanel, Anchor.WEST, Fill.NONE);
        colorPanel.addComponent(this.createFontColorChooser(), Anchor.WEST, Fill.NONE);
        colorPanel.addComponent(this.createBackgroundColorChooser(), Anchor.WEST, Fill.NONE);
        this.paramPanel.incrRow();
        this.paramPanel.addComponent(this.createPreview(), Colspan.CS_2, Anchor.SOUTHWEST, Fill.NONE);
        this.addVerticalGlue();
        this.paramPanel.setLock(this.attributeSet.isFontEnabled());
        if (!this.attributeSet.isFontColorEnabled()) {
            this.fontColorButton.setEnabled(false);
        }
        if (!this.attributeSet.isFontStyleEnabled()) {
            this.fontStyleSelect.setEnabled(false);
        }
    }

    private JComponent createPreview() {
        GridPanel panel = new GridPanel();
        this.attributeSet.setFixedSize(new Dimension(500, 72));
        this.label = this.attributeSet.toJLabel();
        this.label.setForeground(this.attributeSet.getForeground());
        this.label.setBackground(this.attributeSet.getBackground());
        panel.addComponent((JComponent)this.label, Anchor.SOUTHWEST, Fill.HORIZONTAL);
        return panel;
    }
}

