/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.fo;

import java.awt.Color;
import java.awt.Font;
import javax.swing.UIManager;

public class FontAttributes {
    private Color backgroundColor = Color.white;
    private Font font;
    private boolean fontColorEnabled = true;
    private boolean fontEnabled = false;
    private boolean fontStyleEnabled = true;
    private Color foregroundColor = Color.black;

    public Color getBackgroundColor() {
        if (this.backgroundColor == null) {
            return Color.white;
        }
        return this.backgroundColor;
    }

    public Font getFont() {
        if (this.font == null) {
            return UIManager.getDefaults().getFont("Label.font");
        }
        return this.font;
    }

    public Color getForegroundColor() {
        if (this.foregroundColor == null) {
            return Color.black;
        }
        return this.foregroundColor;
    }

    public boolean isFontColorEnabled() {
        return this.fontColorEnabled;
    }

    public boolean isFontEnabled() {
        return this.fontEnabled;
    }

    public boolean isFontStyleEnabled() {
        return this.fontStyleEnabled;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setFontColorEnabled(boolean fontColorEnabled) {
        this.fontColorEnabled = fontColorEnabled;
    }

    public void setFontEnabled(boolean fontEnabled) {
        this.fontEnabled = fontEnabled;
        if (!fontEnabled) {
            this.reset();
        }
    }

    private void reset() {
        this.setFont(null);
        this.setForegroundColor(null);
        this.setBackgroundColor(null);
    }

    public void setFontStyleEnabled(boolean fontStyleEnabled) {
        this.fontStyleEnabled = fontStyleEnabled;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public void autoEnable() {
        if (this.font != null || this.foregroundColor != null || this.backgroundColor != null) {
            this.setFontEnabled(true);
        } else {
            this.setFontEnabled(false);
        }
    }
}

