/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.fo;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.dbdoclet.Identifier;
import org.dbdoclet.jive.Anchor;
import org.dbdoclet.jive.Colspan;
import org.dbdoclet.jive.Fill;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.Rowspan;
import org.dbdoclet.jive.dialog.AbstractDialog;
import org.dbdoclet.jive.fo.FoAttributePanel;
import org.dbdoclet.jive.fo.FoAttributeSet;
import org.dbdoclet.jive.fo.FontPanel;
import org.dbdoclet.jive.fo.LinePanel;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.service.ResourceServices;
import org.dbdoclet.unit.Length;

public class FoAttributeSetDialog
extends AbstractDialog
implements ActionListener,
ChangeListener {
    public static final String COLOR_CHAR = "\u25fc";
    public static final int MONOSPACED = 2;
    public static final int STANDARD = 1;
    private static final long serialVersionUID = 1L;
    private FoAttributeSet attributeSet;
    private JButton cancelButton;
    private boolean canceled = false;
    private JSpinner endIndentSpinner;
    private JCheckBox frameBottomCheckBox;
    private JButton frameColorButton;
    private JCheckBox frameEnabledCheckBox;
    private JCheckBox frameLeftCheckBox;
    private GridPanel framePanel;
    private JCheckBox frameRightCheckBox;
    private JComboBox<String> frameStyleComboBox;
    private JCheckBox frameTopCheckBox;
    private JSpinner frameWidthSpinner;
    private FontPanel fontPanel;
    private LinePanel linePanel;
    private boolean mapGenericFontNames = true;
    private JSpinner paddingSpinner;
    private ResourceBundle res;
    private JSpinner spaceAfterMaximumSpinner;
    private JSpinner spaceAfterMinimumSpinner;
    private JSpinner spaceAfterOptimumSpinner;
    private JSpinner spaceBeforeMaximumSpinner;
    private JSpinner spaceBeforeMinimumSpinner;
    private JSpinner spaceBeforeOptimumSpinner;
    private JCheckBox spacingEnabledCheckBox;
    private GridPanel spacingPanel;
    private JSpinner startIndentSpinner;
    private JSpinner textIndentSpinner;
    private JiveFactory jf;
    private String[] fontList;

    public FoAttributeSetDialog(Frame frame, FoAttributeSet attributeSet) {
        super((Window)frame, "FontChooser", true);
        if (attributeSet == null) {
            attributeSet = new FoAttributeSet(new Font("Dialog", 0, 12), Color.black);
        }
        this.attributeSet = attributeSet.clone();
    }

    public static void main(String[] args) {
        JiveFactory.getInstance(Locale.getDefault());
        FoAttributeSet attributeSet = new FoAttributeSet(new Font("Dialog", 0, 12), Color.black);
        attributeSet.setFontEnabled(true);
        FoAttributeSetDialog dlg = new FoAttributeSetDialog(null, attributeSet);
        dlg.setFontList(new String[]{"Arial", "Courier", "Helvetica", "Times Roman", "monospaced", "sans-serif", "serif"});
        dlg.createGui();
        dlg.setVisible(true);
        FoAttributeSet aset = dlg.getAttributeSet();
        System.out.println("Aktiviert: " + aset.isActivated());
        System.out.println("Register Zeile: " + aset.isLineEnabled());
        System.out.println("Zeile - text-align: " + aset.getTextAlign());
        System.out.println("Zeile - wrap-option: " + aset.getWrapOption());
        System.out.println("Zeile - background: " + aset.getBackground());
        System.out.println("Zeile - line-height: " + aset.getLineHeight());
        System.out.println("Schriftart: " + aset.getFont());
        System.out.println("Abstand davor: " + aset.getSpaceBeforeOptimum());
        System.out.println("Abstand danach: " + aset.getSpaceAfterOptimum());
        System.out.println("Rahmenbreite: " + aset.getFrameWidth());
        System.out.println("Rahmenart: " + aset.getFrameStyle());
        System.out.println("Rahmenfarbe: " + aset.getFrameColor());
        System.out.println("Zeileneinzug 1. Zeile: " + aset.getTextIndent());
        System.out.println("Zeileneinzug Startbreich: " + aset.getStartIndent());
        System.out.println("Zeileneinzug Endbereich: " + aset.getEndIndent());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Color color;
        String cmd = event.getActionCommand();
        Object source = event.getSource();
        if (cmd == null) {
            return;
        }
        if (source != null && source == this.spacingEnabledCheckBox) {
            this.attributeSet.setSpacingEnabled(this.spacingEnabledCheckBox.isSelected());
            this.spacingPanel.setLock(this.spacingEnabledCheckBox.isSelected());
        }
        if (source != null && source == this.frameEnabledCheckBox) {
            this.attributeSet.setFrameEnabled(this.frameEnabledCheckBox.isSelected());
            this.framePanel.setLock(this.frameEnabledCheckBox.isSelected());
        }
        if (source != null && source == this.frameTopCheckBox) {
            this.attributeSet.setFrameTop(this.frameTopCheckBox.isSelected());
        }
        if (source != null && source == this.frameBottomCheckBox) {
            this.attributeSet.setFrameBottom(this.frameBottomCheckBox.isSelected());
        }
        if (source != null && source == this.frameRightCheckBox) {
            this.attributeSet.setFrameRight(this.frameRightCheckBox.isSelected());
        }
        if (source != null && source == this.frameLeftCheckBox) {
            this.attributeSet.setFrameLeft(this.frameLeftCheckBox.isSelected());
        }
        if (source != null && source == this.frameStyleComboBox) {
            this.attributeSet.setFrameStyle(this.frameStyleComboBox.getSelectedItem().toString());
        }
        if (source != null && source == this.frameColorButton && (color = JColorChooser.showDialog(this, ResourceServices.getString(this.res, "C_COLOR"), this.attributeSet.getFrameColor())) != null) {
            this.attributeSet.setFrameColor(color);
            this.frameColorButton.setForeground(color);
        }
        if (cmd.equalsIgnoreCase("cancel")) {
            this.setCanceled(true);
            this.setVisible(false);
        }
        if (cmd.equalsIgnoreCase("ok")) {
            this.setCanceled(false);
            this.setVisible(false);
        }
    }

    public void createGui() {
        this.jf = JiveFactory.getInstance();
        this.res = this.jf.getResourceBundle();
        GridPanel panel = new GridPanel();
        this.getRootPane().setContentPane(panel);
        JTabbedPane tabbedPane = new JTabbedPane();
        panel.addComponent((JComponent)tabbedPane, Anchor.CENTER, Fill.BOTH);
        this.fontPanel = new FontPanel(this, this.attributeSet);
        if (this.fontList != null) {
            this.fontPanel.setFontList(this.fontList);
        }
        JPanel spacingPanel = this.createSpacingPanel();
        JPanel framePanel = this.createFramePanel();
        this.linePanel = new LinePanel(this, this.attributeSet);
        if (this.attributeSet.isFontType()) {
            tabbedPane.addTab(ResourceServices.getString(this.res, "C_FONT"), this.fontPanel);
        }
        if (this.attributeSet.isSpacingType()) {
            tabbedPane.addTab(ResourceServices.getString(this.res, "C_SPACING"), spacingPanel);
        }
        if (this.attributeSet.isFrameType()) {
            tabbedPane.addTab(ResourceServices.getString(this.res, "C_FRAME"), framePanel);
        }
        if (this.attributeSet.isLineType()) {
            tabbedPane.addTab(ResourceServices.getString(this.res, "C_LINE"), this.linePanel);
        }
        JButton okButton = this.jf.createButton(null, ResourceServices.getString(this.res, "C_OK"));
        okButton.setActionCommand("ok");
        okButton.addActionListener(this);
        panel.addButton(okButton);
        this.cancelButton = this.jf.createButton(null, ResourceServices.getString(this.res, "C_CANCEL"));
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        panel.addButton(this.cancelButton);
        panel.prepare();
        this.getRootPane().setDefaultButton(okButton);
        this.pack();
        this.center();
        this.spacingEnabledCheckBox.setSelected(this.attributeSet.isSpacingEnabled());
        this.frameEnabledCheckBox.setSelected(this.attributeSet.isFrameEnabled());
    }

    public FoAttributeSet getAttributeSet() {
        this.updateAttributeSet();
        return this.attributeSet;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public void setFontList(String[] fontList) {
        this.fontList = fontList;
        if (this.fontPanel != null) {
            this.fontPanel.setFontList(fontList);
        }
    }

    public void setFontSize(int size) {
        this.fontPanel.setFontSize(size);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        JComponent comp = (JComponent)event.getSource();
        this.attributeSet.setChanged(true);
        if (comp == this.spaceBeforeMinimumSpinner) {
            this.attributeSet.setSpaceBeforeMinimum(FoAttributePanel.getDistance(this.spaceBeforeMinimumSpinner));
        }
        if (comp == this.spaceBeforeOptimumSpinner) {
            this.attributeSet.setSpaceBeforeOptimum(FoAttributePanel.getDistance(this.spaceBeforeOptimumSpinner));
        }
        if (comp == this.spaceBeforeMaximumSpinner) {
            this.attributeSet.setSpaceBeforeMaximum(FoAttributePanel.getDistance(this.spaceBeforeMaximumSpinner));
        }
        if (comp == this.spaceAfterMinimumSpinner) {
            this.attributeSet.setSpaceAfterMinimum(FoAttributePanel.getDistance(this.spaceAfterMinimumSpinner));
        }
        if (comp == this.spaceAfterOptimumSpinner) {
            this.attributeSet.setSpaceAfterOptimum(FoAttributePanel.getDistance(this.spaceAfterOptimumSpinner));
        }
        if (comp == this.spaceAfterMaximumSpinner) {
            this.attributeSet.setSpaceAfterMaximum(FoAttributePanel.getDistance(this.spaceAfterMaximumSpinner));
        }
        if (comp == this.paddingSpinner) {
            this.attributeSet.setPadding(FoAttributePanel.getDistance(this.paddingSpinner));
        }
        if (comp == this.textIndentSpinner) {
            this.attributeSet.setTextIndent(FoAttributePanel.getDistance(this.textIndentSpinner));
        }
        if (comp == this.startIndentSpinner) {
            this.attributeSet.setStartIndent(FoAttributePanel.getDistance(this.startIndentSpinner));
        }
        if (comp == this.endIndentSpinner) {
            this.attributeSet.setEndIndent(FoAttributePanel.getDistance(this.endIndentSpinner));
        }
        if (comp == this.frameWidthSpinner) {
            this.attributeSet.setFrameWidth(FoAttributePanel.getDistance(this.frameWidthSpinner));
        }
    }

    public void updateAttributeSet() {
        if (this.attributeSet != null && this.frameTopCheckBox != null) {
            String family = this.fontPanel.getFontFamily();
            if (family != null) {
                if (this.mapGenericFontNames) {
                    if (family.equalsIgnoreCase("times roman")) {
                        family = "Serif";
                    }
                    if (family.equalsIgnoreCase("helvetica") || family.equalsIgnoreCase("dialog")) {
                        family = "SansSerif";
                    }
                    if (family.equalsIgnoreCase("courier")) {
                        family = "Monospaced";
                    }
                }
                int style = this.fontPanel.getFontStyle();
                int size = this.fontPanel.getFontSize();
                Font font = new Font(family, style, size);
                this.attributeSet.setFont(font);
            }
            this.attributeSet.setSpaceBeforeMinimum(FoAttributePanel.getDistance(this.spaceBeforeMinimumSpinner));
            this.attributeSet.setSpaceBeforeOptimum(FoAttributePanel.getDistance(this.spaceBeforeOptimumSpinner));
            this.attributeSet.setSpaceBeforeMaximum(FoAttributePanel.getDistance(this.spaceBeforeMaximumSpinner));
            this.attributeSet.setSpaceAfterMinimum(FoAttributePanel.getDistance(this.spaceAfterMinimumSpinner));
            this.attributeSet.setSpaceAfterOptimum(FoAttributePanel.getDistance(this.spaceAfterOptimumSpinner));
            this.attributeSet.setSpaceAfterMaximum(FoAttributePanel.getDistance(this.spaceAfterMaximumSpinner));
            this.attributeSet.setPadding(FoAttributePanel.getDistance(this.paddingSpinner));
            this.attributeSet.setFrameWidth(FoAttributePanel.getDistance(this.frameWidthSpinner));
            this.attributeSet.setFrameTop(this.frameTopCheckBox.isSelected());
            this.attributeSet.setFrameBottom(this.frameBottomCheckBox.isSelected());
            this.attributeSet.setFrameRight(this.frameRightCheckBox.isSelected());
            this.attributeSet.setFrameLeft(this.frameLeftCheckBox.isSelected());
            this.attributeSet.setWrapOption(this.linePanel.getWrapOption());
            this.attributeSet.setTextAlign(this.linePanel.getTextAlign());
            this.attributeSet.setLineWidth(FoAttributePanel.getDistance(this.linePanel.getWidthSpinner()));
        }
    }

    private JPanel createFramePanel() {
        GridPanel panel = new GridPanel();
        panel.addSeparator(4, ResourceServices.getString(this.res, "C_FRAME"));
        panel.incrRow();
        this.frameEnabledCheckBox = this.jf.createCheckBox(null, ResourceServices.getString(this.res, "C_ACTIVATE"));
        this.frameEnabledCheckBox.setSelected(false);
        this.frameEnabledCheckBox.setActionCommand("frame-enabled");
        this.frameEnabledCheckBox.addActionListener(this);
        panel.addComponent(this.frameEnabledCheckBox);
        panel.incrRow();
        this.framePanel = new GridPanel();
        GridPanel frameSidesPanel = new GridPanel();
        frameSidesPanel.setBorder(BorderFactory.createTitledBorder(ResourceServices.getString(this.res, "C_VISIBLE_SIDES")));
        this.framePanel.addComponent((JComponent)frameSidesPanel, Colspan.CS_4);
        this.framePanel.incrRow();
        this.frameTopCheckBox = this.jf.createCheckBox(null, ResourceServices.getString(this.res, "C_TOP"));
        this.frameTopCheckBox.setSelected(this.attributeSet.isFrameTop());
        this.frameTopCheckBox.addActionListener(this);
        frameSidesPanel.addComponent(this.frameTopCheckBox);
        this.frameLeftCheckBox = this.jf.createCheckBox(null, ResourceServices.getString(this.res, "C_LEFT"));
        this.frameLeftCheckBox.setSelected(this.attributeSet.isFrameLeft());
        this.frameLeftCheckBox.addActionListener(this);
        frameSidesPanel.addComponent(this.frameLeftCheckBox);
        this.frameBottomCheckBox = this.jf.createCheckBox(null, ResourceServices.getString(this.res, "C_BOTTOM"));
        this.frameBottomCheckBox.setSelected(this.attributeSet.isFrameBottom());
        this.frameBottomCheckBox.addActionListener(this);
        frameSidesPanel.addComponent(this.frameBottomCheckBox);
        this.frameRightCheckBox = this.jf.createCheckBox(null, ResourceServices.getString(this.res, "C_RIGHT"));
        this.frameRightCheckBox.setSelected(this.attributeSet.isFrameRight());
        this.frameRightCheckBox.addActionListener(this);
        frameSidesPanel.addComponent(this.frameRightCheckBox);
        this.frameWidthSpinner = this.jf.createDistanceSpinner(new Identifier("frame.width"));
        this.frameWidthSpinner.setValue(Length.valueOf(this.attributeSet.getFrameWidth()));
        this.frameWidthSpinner.addChangeListener(this);
        this.framePanel.addLabeledComponent(ResourceServices.getString(this.res, "C_WIDTH"), (JComponent)this.frameWidthSpinner);
        this.frameStyleComboBox = this.jf.createComboBox(new Identifier("fo.frame.style"), FoAttributeSet.FRAME_STYLE_LIST);
        this.frameStyleComboBox.setSelectedItem(this.attributeSet.getFrameStyle());
        this.frameStyleComboBox.addActionListener(this);
        this.framePanel.addLabeledComponent(ResourceServices.getString(this.res, "C_FRAME_STYLE"), this.frameStyleComboBox);
        this.framePanel.incrRow();
        this.frameColorButton = this.jf.createButton(null, "\u25fc " + ResourceServices.getString(this.res, "C_COLOR") + "...");
        this.frameColorButton.addActionListener(this);
        this.framePanel.addComponent((JComponent)this.frameColorButton, Colspan.CS_4, Rowspan.RS_1);
        panel.addComponent(this.framePanel);
        panel.incrRow();
        panel.addVerticalGlue();
        this.framePanel.setLock(this.attributeSet.isFrameEnabled());
        return panel;
    }

    private JPanel createSpacingPanel() {
        GridPanel panel = new GridPanel();
        panel.addSeparator(4, ResourceServices.getString(this.res, "C_SPACING"));
        this.spacingEnabledCheckBox = this.jf.createCheckBox(null, ResourceServices.getString(this.res, "C_ACTIVATE"));
        this.spacingEnabledCheckBox.setSelected(false);
        this.spacingEnabledCheckBox.setActionCommand("spacing-enabled");
        this.spacingEnabledCheckBox.addActionListener(this);
        panel.addComponent(this.spacingEnabledCheckBox);
        panel.incrRow();
        this.spacingPanel = new GridPanel();
        this.spacingPanel.addSeparator(4, ResourceServices.getString(this.res, "C_BEFORE"));
        this.spaceBeforeMinimumSpinner = this.jf.createDistanceSpinner(new Identifier("space-before.minimum"));
        this.spaceBeforeMinimumSpinner.setValue(Length.valueOf(this.attributeSet.getSpaceBeforeMinimum()));
        if (this.attributeSet.isSpaceBeforeMinimumVisible()) {
            this.spaceBeforeMinimumSpinner.addChangeListener(this);
            this.spacingPanel.addLabeledComponent("space-before.minimum", (JComponent)this.spaceBeforeMinimumSpinner);
        }
        this.spaceBeforeOptimumSpinner = this.jf.createDistanceSpinner(new Identifier("space-before.optimum"));
        this.spaceBeforeOptimumSpinner.setValue(Length.valueOf(this.attributeSet.getSpaceBeforeOptimum()));
        this.spaceBeforeOptimumSpinner.addChangeListener(this);
        this.spacingPanel.addLabeledComponent("space-before.optimum", (JComponent)this.spaceBeforeOptimumSpinner);
        this.spacingPanel.incrRow();
        this.spaceBeforeMaximumSpinner = this.jf.createDistanceSpinner(new Identifier("space-before.maximum"));
        this.spaceBeforeMaximumSpinner.setValue(Length.valueOf(this.attributeSet.getSpaceBeforeMaximum()));
        if (this.attributeSet.isSpaceBeforeMaximumVisible()) {
            this.spaceBeforeMaximumSpinner.addChangeListener(this);
            this.spacingPanel.addLabeledComponent("space-before.maximum", (JComponent)this.spaceBeforeMaximumSpinner);
            this.spacingPanel.incrRow();
        }
        this.spacingPanel.addSeparator(4, ResourceServices.getString(this.res, "C_AFTER"));
        this.spaceAfterMinimumSpinner = this.jf.createDistanceSpinner(new Identifier("space-after.minimum"));
        this.spaceAfterMinimumSpinner.setValue(Length.valueOf(this.attributeSet.getSpaceAfterMinimum()));
        if (this.attributeSet.isSpaceAfterMinimumVisible()) {
            this.spaceAfterMinimumSpinner.addChangeListener(this);
            this.spacingPanel.addLabeledComponent("space-after.minimum", (JComponent)this.spaceAfterMinimumSpinner);
        }
        this.spaceAfterOptimumSpinner = this.jf.createDistanceSpinner(new Identifier("space-after.optimum"));
        this.spaceAfterOptimumSpinner.setValue(Length.valueOf(this.attributeSet.getSpaceAfterOptimum()));
        this.spaceAfterOptimumSpinner.addChangeListener(this);
        this.spacingPanel.addLabeledComponent("space-after.optimum", (JComponent)this.spaceAfterOptimumSpinner);
        this.spacingPanel.incrRow();
        this.spaceAfterMaximumSpinner = this.jf.createDistanceSpinner(new Identifier("space-after.maximum"));
        this.spaceAfterMaximumSpinner.setValue(Length.valueOf(this.attributeSet.getSpaceAfterMaximum()));
        if (this.attributeSet.isSpaceAfterMaximumVisible()) {
            this.spaceAfterMaximumSpinner.addChangeListener(this);
            this.spacingPanel.addLabeledComponent("space-after.maximum", (JComponent)this.spaceAfterMaximumSpinner);
            this.spacingPanel.incrRow();
        }
        this.spacingPanel.incrRow();
        this.spacingPanel.addSeparator(4, ResourceServices.getString(this.res, "C_PADDING"));
        this.paddingSpinner = this.jf.createDistanceSpinner(new Identifier("padding"));
        this.paddingSpinner.setValue(Length.valueOf(this.attributeSet.getPadding()));
        this.paddingSpinner.addChangeListener(this);
        this.spacingPanel.addLabeledComponent("padding", (JComponent)this.paddingSpinner);
        this.textIndentSpinner = this.jf.createDistanceSpinner(new Identifier("text-indent"));
        this.textIndentSpinner.setValue(Length.valueOf(this.attributeSet.getTextIndent()));
        this.textIndentSpinner.addChangeListener(this);
        this.spacingPanel.addLabeledComponent("text-indent", (JComponent)this.textIndentSpinner);
        this.spacingPanel.incrRow();
        this.startIndentSpinner = this.jf.createDistanceSpinner(new Identifier("start-indent"));
        this.startIndentSpinner.setValue(Length.valueOf(this.attributeSet.getStartIndent()));
        this.startIndentSpinner.addChangeListener(this);
        this.spacingPanel.addLabeledComponent("start-indent", (JComponent)this.startIndentSpinner);
        this.endIndentSpinner = this.jf.createDistanceSpinner(new Identifier("end-indent"));
        this.endIndentSpinner.setValue(Length.valueOf(this.attributeSet.getEndIndent()));
        this.endIndentSpinner.addChangeListener(this);
        this.spacingPanel.addLabeledComponent("end-indent", (JComponent)this.endIndentSpinner);
        this.spacingPanel.incrRow();
        panel.addComponent(this.spacingPanel);
        panel.incrRow();
        panel.addVerticalGlue();
        this.spacingPanel.setLock(this.attributeSet.isSpacingEnabled());
        return panel;
    }
}

