/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.fo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.fo.FoAttributeSet;
import org.dbdoclet.jive.fo.FoAttributeSetDialog;

public class FoAttributeSetChooser
extends JTable
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private HashMap<String, FoAttributeSet> dataList;
    private final String[] fontFamilyList;
    private FontListModel model;

    public FoAttributeSetChooser() {
        String[] fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        FoAttributeSet[] attributeSetList = new FoAttributeSet[fontList.length];
        int index = 0;
        for (String fontFamily : fontList) {
            Font font = new Font(fontFamily, 0, 12);
            FoAttributeSet preview = new FoAttributeSet(fontFamily, font, Color.black);
            attributeSetList[index++] = preview;
        }
        this.fontFamilyList = null;
        this.init(attributeSetList);
    }

    public FoAttributeSetChooser(FoAttributeSet[] attributeSetList, String[] fontFamilyList) {
        this.fontFamilyList = fontFamilyList;
        this.init(attributeSetList);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source != null && source instanceof JButton) {
            String name = event.getActionCommand();
            FoAttributeSet attributeSet = this.dataList.get(name);
            FoAttributeSetDialog fontChooser = new FoAttributeSetDialog(JiveFactory.findParentFrame(this), attributeSet);
            if (this.fontFamilyList != null) {
                fontChooser.setFontList(this.fontFamilyList);
            }
            fontChooser.createGui();
            fontChooser.setVisible(true);
            if (!fontChooser.isCanceled()) {
                FoAttributeSet as = fontChooser.getAttributeSet();
                if (as.isActivated()) {
                    attributeSet.copy(as);
                } else {
                    attributeSet.reset();
                }
            }
            this.model.fireTableDataChanged();
        }
    }

    private void init(FoAttributeSet[] attributeSetList) {
        int maxHeight = 12;
        this.dataList = new HashMap();
        if (attributeSetList != null) {
            for (FoAttributeSet attributeSet : attributeSetList) {
                JLabel label = attributeSet.toJLabel();
                int height = label.getPreferredSize().height;
                if (height > maxHeight) {
                    maxHeight = height;
                }
                attributeSet.setChooser(this);
                this.dataList.put(attributeSet.getText(), attributeSet);
            }
        }
        this.model = new FontListModel(attributeSetList);
        this.setModel(this.model);
        this.setColumnModel(new FontListColumnModel());
        this.setRowHeight(maxHeight);
        this.setShowGrid(false);
        this.setSelectionMode(0);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setCellSelectionEnabled(false);
        this.setTableHeader(null);
        this.setDefaultRenderer(FoAttributeSet.class, new FontListCellRenderer());
        this.setDefaultEditor(FoAttributeSet.class, new FontListEditor(this, this.fontFamilyList));
    }

    private JButton createButton(FoAttributeSet preview) {
        JButton button = new JButton(preview.getText());
        button.setHorizontalAlignment(2);
        button.setFocusPainted(true);
        button.setActionCommand(preview.getText());
        button.addActionListener(this);
        return button;
    }

    class FontListModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public static final int COLUMN_INDEX_NAME = 0;
        public static final int COLUMN_INDEX_PREVIEW = 1;
        private static final int COLUMN_COUNT = 2;
        private final FoAttributeSet[] previews;

        FontListModel(FoAttributeSet[] previews) {
            this.previews = previews;
        }

        public Class<FoAttributeSet> getColumnClass(int c) {
            return FoAttributeSet.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.previews.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.previews[row];
                }
                case 1: {
                    return this.previews[row];
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }
    }

    class FontListEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        private FoAttributeSet attributeSet;
        private final String[] fontFamilyList;
        private final FoAttributeSetChooser fontTable;
        private JButton button;
        private int row;

        public FontListEditor(FoAttributeSetChooser table, String[] fontFamilyList) {
            this.fontTable = table;
            this.fontFamilyList = fontFamilyList;
        }

        @Override
        public Object getCellEditorValue() {
            return this.attributeSet;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof FoAttributeSet && column == 0) {
                this.attributeSet = (FoAttributeSet)value;
                this.row = row;
                this.button = FoAttributeSetChooser.this.createButton(this.attributeSet);
                return this.button;
            }
            return null;
        }

        public void mouseClicked(MouseEvent event) {
            if (!event.isConsumed() && event.getClickCount() == 2) {
                this.showFoAttributeSetDialog();
                this.fireEditingStopped();
                ((FontListModel)this.fontTable.getModel()).fireTableCellUpdated(this.row, 1);
            }
        }

        private void showFoAttributeSetDialog() {
            FoAttributeSetDialog fontChooser = new FoAttributeSetDialog(JiveFactory.findParentFrame(this.fontTable), this.attributeSet);
            if (this.fontFamilyList != null) {
                fontChooser.setFontList(this.fontFamilyList);
            }
            fontChooser.createGui();
            fontChooser.setVisible(true);
            if (!fontChooser.isCanceled()) {
                this.attributeSet.copy(fontChooser.getAttributeSet());
            }
        }
    }

    class FontListColumnModel
    extends DefaultTableColumnModel {
        private static final int COLUMN_WIDTH_1 = 2500;
        private static final int COLUMN_WIDTH_2 = 2500;
        private static final long serialVersionUID = 1L;

        public FontListColumnModel() {
            TableColumn col = new TableColumn(0);
            col.setPreferredWidth(2500);
            this.addColumn(col);
            col = new TableColumn(1);
            col.setPreferredWidth(2500);
            this.addColumn(col);
        }
    }

    class FontListCellRenderer
    implements TableCellRenderer {
        private static final String defText = "Gallia est omnis divisa in partes tres, quarum unam incolunt Belgae, aliam Aquitani, tertiam qui ipsorum lingua Celtae, nostra Galli appellantur.";

        FontListCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int row, int column) {
            if (value instanceof FoAttributeSet) {
                FoAttributeSet preview = (FoAttributeSet)value;
                JLabel label = preview.toJLabel();
                if (column == 0) {
                    JButton button = FoAttributeSetChooser.this.createButton(preview);
                    return button;
                }
                if (column == 1) {
                    label.setText(defText);
                    label.setFont(preview.getFont());
                    label.setForeground(preview.getForeground());
                    label.setBackground(preview.getBackground());
                    if (preview.isActivated()) {
                        label.setEnabled(true);
                    } else {
                        label.setEnabled(false);
                    }
                    return label;
                }
            }
            if (value instanceof JCheckBox) {
                JCheckBox onOff = (JCheckBox)value;
                onOff.setOpaque(true);
                return onOff;
            }
            return null;
        }
    }
}

