/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.fo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.dbdoclet.jive.fo.FoAttributeSetChooser;
import org.dbdoclet.jive.fo.FontAttributes;
import org.dbdoclet.jive.fo.FrameAttributes;
import org.dbdoclet.jive.fo.LineAttributes;
import org.dbdoclet.jive.fo.SpacingAttributes;

public class FoAttributeSet {
    public static final int FONT_SET = 1;
    public static final int FRAME_SET = 4;
    public static final String[] FRAME_STYLE_LIST = new String[]{"solid", "dashed", "dotted", "double", "inset", "outset", "groove", "ridge", "none"};
    public static final int SPACING_SET = 2;
    private static final Border border = BorderFactory.createEmptyBorder(4, 4, 4, 4);
    public static final int LINE_SET = 4;
    private static final String defText = "\"Was gl\u00e4nzt, ist f\u00fcr den Augenblick geboren; // Das Echte bleibt der Nachwelt unverloren.\" - Johann Wolfgang von Goethe, Faust I, Vers 73 f. / Dichter";
    private boolean changed = false;
    private Dimension fixedSize = null;
    private FontAttributes fontAttributes;
    private FrameAttributes frameAttributes;
    private SpacingAttributes spacingAttributes;
    private LineAttributes lineAttributes;
    private int type = 7;
    private String text;
    private JLabel label;

    public FoAttributeSet(Font font, Color color) {
        this(defText, font, color);
    }

    public FoAttributeSet(String text, Font font, Color color) {
        if (text == null) {
            text = defText;
        }
        if (color == null) {
            color = Color.black;
        }
        this.spacingAttributes = new SpacingAttributes();
        this.fontAttributes = new FontAttributes();
        this.frameAttributes = new FrameAttributes();
        this.lineAttributes = new LineAttributes();
        this.setText(text);
        this.setFont(font);
        this.setForeground(color);
        this.setBackground(Color.white);
    }

    public boolean changed() {
        return this.changed;
    }

    public FoAttributeSet clone() {
        FoAttributeSet clone = new FoAttributeSet(this.getText(), this.getFont(), this.getForeground());
        clone.setType(this.getType());
        clone.setFontEnabled(this.isFontEnabled());
        clone.setFontColorEnabled(this.isFontColorEnabled());
        clone.setFontStyleEnabled(this.isFontStyleEnabled());
        clone.setFont(this.getFont());
        clone.setForeground(this.getForeground());
        clone.setBackground(this.getBackground());
        clone.setSpacingEnabled(this.isSpacingEnabled());
        clone.setSpaceBeforeMinimum(this.getSpaceBeforeMinimum());
        clone.setSpaceBeforeMinimumVisible(this.isSpaceBeforeMinimumVisible());
        clone.setSpaceBeforeOptimum(this.getSpaceBeforeOptimum());
        clone.setSpaceBeforeMaximum(this.getSpaceBeforeMaximum());
        clone.setSpaceBeforeMaximumVisible(this.isSpaceBeforeMaximumVisible());
        clone.setSpaceAfterMinimum(this.getSpaceAfterMinimum());
        clone.setSpaceAfterMinimumVisible(this.isSpaceAfterMinimumVisible());
        clone.setSpaceAfterOptimum(this.getSpaceAfterOptimum());
        clone.setSpaceAfterMaximum(this.getSpaceAfterMaximum());
        clone.setSpaceAfterMaximumVisible(this.isSpaceAfterMaximumVisible());
        clone.setPadding(this.getPadding());
        clone.setTextIndent(this.getTextIndent());
        clone.setStartIndent(this.getStartIndent());
        clone.setEndIndent(this.getEndIndent());
        clone.setFrameEnabled(this.isFrameEnabled());
        clone.setFrameTop(this.isFrameTop());
        clone.setFrameBottom(this.isFrameBottom());
        clone.setFrameRight(this.isFrameRight());
        clone.setFrameLeft(this.isFrameLeft());
        clone.setFrameWidth(this.getFrameWidth());
        clone.setFrameStyle(this.getFrameStyle());
        clone.setFrameColor(this.getFrameColor());
        clone.setLineEnabled(this.isLineEnabled());
        clone.setWrapOption(this.getWrapOption());
        clone.setTextAlign(this.getTextAlign());
        clone.setLineWidth(this.getLineWidth());
        clone.setLineHeight(this.getLineHeight());
        return clone;
    }

    public void copy(FoAttributeSet other) {
        this.setText(other.getText());
        this.setType(this.getType());
        this.setFontEnabled(other.isFontEnabled());
        this.setFontColorEnabled(other.isFontColorEnabled());
        this.setFontStyleEnabled(other.isFontStyleEnabled());
        this.setFont(other.getFont());
        this.setForeground(other.getForeground());
        this.setBackground(other.getBackground());
        this.setSpacingEnabled(other.isSpacingEnabled());
        this.setSpaceBeforeMinimum(other.getSpaceBeforeMinimum());
        this.setSpaceBeforeOptimum(other.getSpaceBeforeOptimum());
        this.setSpaceBeforeMaximum(other.getSpaceBeforeMaximum());
        this.setSpaceAfterMinimum(other.getSpaceAfterMinimum());
        this.setSpaceAfterOptimum(other.getSpaceAfterOptimum());
        this.setSpaceAfterMaximum(other.getSpaceAfterMaximum());
        this.setPadding(other.getPadding());
        this.setTextIndent(other.getTextIndent());
        this.setStartIndent(other.getStartIndent());
        this.setEndIndent(other.getEndIndent());
        this.setFrameEnabled(other.isFrameEnabled());
        this.setFrameTop(other.isFrameTop());
        this.setFrameBottom(other.isFrameBottom());
        this.setFrameRight(other.isFrameRight());
        this.setFrameLeft(other.isFrameLeft());
        this.setFrameWidth(other.getFrameWidth());
        this.setFrameStyle(other.getFrameStyle());
        this.setFrameColor(other.getFrameColor());
        this.setLineEnabled(other.isLineEnabled());
        this.setWrapOption(other.getWrapOption());
        this.setTextAlign(other.getTextAlign());
        this.setLineWidth(other.getLineWidth());
        this.setLineHeight(other.getLineHeight());
    }

    public Color getBackground() {
        return this.fontAttributes.getBackgroundColor();
    }

    public String getEndIndent() {
        return this.spacingAttributes.getEndIndent();
    }

    public Font getFont() {
        return this.fontAttributes.getFont();
    }

    public String getFontFamily() {
        return this.getFont().getFamily();
    }

    public int getFontSize() {
        return this.getFont().getSize();
    }

    public int getFontStyle() {
        return this.getFont().getStyle();
    }

    public Color getForeground() {
        return this.fontAttributes.getForegroundColor();
    }

    public String getLineWidth() {
        return this.lineAttributes.getLineWidth();
    }

    public Color getFrameColor() {
        return this.frameAttributes.getFrameColor();
    }

    public String getFrameStyle() {
        return this.frameAttributes.getFrameStyle();
    }

    public String getFrameWidth() {
        return this.frameAttributes.getFrameWidth();
    }

    public String getLineHeight() {
        return this.lineAttributes.getLineHeight();
    }

    public String getPadding() {
        return this.spacingAttributes.getPadding();
    }

    public String getSpaceAfterMaximum() {
        return this.spacingAttributes.getSpaceAfterMaximum();
    }

    public String getSpaceAfterMinimum() {
        return this.spacingAttributes.getSpaceAfterMinimum();
    }

    public String getSpaceAfterOptimum() {
        return this.spacingAttributes.getSpaceAfterOptimum();
    }

    public String getSpaceBeforeMaximum() {
        return this.spacingAttributes.getSpaceBeforeMaximum();
    }

    public String getSpaceBeforeMinimum() {
        return this.spacingAttributes.getSpaceBeforeMinimum();
    }

    public String getSpaceBeforeOptimum() {
        return this.spacingAttributes.getSpaceBeforeOptimum();
    }

    public String getStartIndent() {
        return this.spacingAttributes.getStartIndent();
    }

    public String getTextAlign() {
        return this.lineAttributes.getTextAlign();
    }

    public String getTextIndent() {
        return this.spacingAttributes.getTextIndent();
    }

    public int getType() {
        return this.type;
    }

    public String getWrapOption() {
        return this.lineAttributes.getWrapOption();
    }

    public boolean isActivated() {
        return this.isLineEnabled() || this.isFrameEnabled() || this.isSpacingEnabled() || this.isFontEnabled();
    }

    public boolean isFontColorEnabled() {
        return this.fontAttributes.isFontColorEnabled();
    }

    public boolean isFontEnabled() {
        return this.fontAttributes.isFontEnabled();
    }

    public boolean isFontStyleEnabled() {
        return this.fontAttributes.isFontStyleEnabled();
    }

    public boolean isFontType() {
        return (this.type & 1) == 1;
    }

    public boolean isFrameBottom() {
        return this.frameAttributes.isFrameBottom();
    }

    public boolean isFrameEnabled() {
        return this.frameAttributes.isFrameEnabled();
    }

    public boolean isFrameLeft() {
        return this.frameAttributes.isFrameLeft();
    }

    public boolean isFrameRight() {
        return this.frameAttributes.isFrameRight();
    }

    public boolean isFrameTop() {
        return this.frameAttributes.isFrameTop();
    }

    public boolean isFrameType() {
        return (this.type & 4) == 4;
    }

    public boolean isLineEnabled() {
        return this.lineAttributes.isLineEnabled();
    }

    public boolean isLineType() {
        return (this.type & 4) == 4;
    }

    public boolean isSpaceAfterMaximumVisible() {
        return this.spacingAttributes.isSpaceAfterMaximumVisible();
    }

    public boolean isSpaceAfterMinimumVisible() {
        return this.spacingAttributes.isSpaceAfterMinimumVisible();
    }

    public boolean isSpaceBeforeMaximumVisible() {
        return this.spacingAttributes.isSpaceBeforeMaximumVisible();
    }

    public boolean isSpaceBeforeMinimumVisible() {
        return this.spacingAttributes.isSpaceBeforeMinimumVisible();
    }

    public boolean isSpacingEnabled() {
        return this.spacingAttributes.isSpacingEnabled();
    }

    public boolean isSpacingType() {
        return (this.type & 2) == 2;
    }

    public void reset() {
        this.setFontEnabled(false);
        this.setFrameEnabled(false);
        this.setSpacingEnabled(false);
        this.setLineEnabled(false);
        this.setFont(null);
        this.setChanged(false);
        this.setForeground(Color.black);
        this.setBackground(Color.white);
    }

    public void setBackground(Color bg) {
        this.fontAttributes.setBackgroundColor(bg);
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public void setChooser(FoAttributeSetChooser foAttributeSetChooser) {
    }

    public void setEndIndent(String endIndent) {
        this.spacingAttributes.setEndIndent(endIndent);
    }

    public void setFixedSize(Dimension fixedSize) {
        this.fixedSize = fixedSize;
    }

    public void setFont(Font font) {
        this.fontAttributes.setFont(font);
    }

    public void setFontColorEnabled(boolean fontColorEnabled) {
        this.fontAttributes.setFontColorEnabled(fontColorEnabled);
    }

    public void setFontEnabled(boolean fontEnabled) {
        this.fontAttributes.setFontEnabled(fontEnabled);
    }

    public void setFontStyleEnabled(boolean fontStyleEnabled) {
        this.fontAttributes.setFontStyleEnabled(fontStyleEnabled);
    }

    public void setForeground(Color foregroundColor) {
        this.fontAttributes.setForegroundColor(foregroundColor);
    }

    public void setLineWidth(String width) {
        this.lineAttributes.setLineWidth(width);
    }

    public void setFrameBottom(boolean frameBottom) {
        this.frameAttributes.setFrameBottom(frameBottom);
    }

    public void setFrameColor(Color frameColor) {
        this.frameAttributes.setFrameColor(frameColor);
    }

    public void setFrameEnabled(boolean frameEnabled) {
        this.frameAttributes.setFrameEnabled(frameEnabled);
    }

    public void setFrameLeft(boolean frameLeft) {
        this.frameAttributes.setFrameLeft(frameLeft);
    }

    public void setFrameRight(boolean frameRight) {
        this.frameAttributes.setFrameRight(frameRight);
    }

    public void setFrameSideEnabled(String side) {
        if (side == null) {
            return;
        }
        if (side.equalsIgnoreCase("top")) {
            this.setFrameTop(true);
        }
        if (side.equalsIgnoreCase("bottom")) {
            this.setFrameBottom(true);
        }
        if (side.equalsIgnoreCase("right")) {
            this.setFrameRight(true);
        }
        if (side.equalsIgnoreCase("left")) {
            this.setFrameLeft(true);
        }
    }

    public void setFrameStyle(String frameStyle) {
        this.frameAttributes.setFrameStyle(frameStyle);
    }

    public void setFrameTop(boolean frameTop) {
        this.frameAttributes.setFrameTop(frameTop);
    }

    public void setFrameWidth(String frameWidth) {
        this.frameAttributes.setFrameWidth(frameWidth);
    }

    public void setLineEnabled(boolean lineEnabled) {
        this.lineAttributes.setLineEnabled(lineEnabled);
    }

    public void setLineHeight(String lineHeight) {
        this.lineAttributes.setLineHeight(lineHeight);
    }

    public void setPadding(String padding) {
        this.spacingAttributes.setPadding(padding);
        this.setFrameColor(null);
    }

    public void setSpaceAfterMaximum(String spaceAfterMaximum) {
        this.spacingAttributes.setSpaceAfterMaximum(spaceAfterMaximum);
    }

    public void setSpaceAfterMaximumVisible(boolean spaceAfterMaximumVisible) {
        this.spacingAttributes.setSpaceAfterMaximumVisible(spaceAfterMaximumVisible);
    }

    public void setSpaceAfterMinimum(String spaceAfterMinimum) {
        this.spacingAttributes.setSpaceAfterMinimum(spaceAfterMinimum);
    }

    public void setSpaceAfterMinimumVisible(boolean spaceAfterMinimumVisible) {
        this.spacingAttributes.setSpaceAfterMinimumVisible(spaceAfterMinimumVisible);
    }

    public void setSpaceAfterOptimum(String spaceAfterOptimum) {
        this.spacingAttributes.setSpaceAfterOptimum(spaceAfterOptimum);
    }

    public void setSpaceBeforeMaximum(String spaceBeforeMaximum) {
        this.spacingAttributes.setSpaceBeforeMaximum(spaceBeforeMaximum);
    }

    public void setSpaceBeforeMaximumVisible(boolean spaceBeforeMaximumVisible) {
        this.spacingAttributes.setSpaceBeforeMaximumVisible(spaceBeforeMaximumVisible);
    }

    public void setSpaceBeforeMinimum(String spaceBeforeMinimum) {
        this.spacingAttributes.setSpaceBeforeMinimum(spaceBeforeMinimum);
    }

    public void setSpaceBeforeMinimumVisible(boolean spaceBeforeMinimumVisible) {
        this.spacingAttributes.setSpaceBeforeMinimumVisible(spaceBeforeMinimumVisible);
    }

    public void setSpaceBeforeOptimum(String spaceBeforeOptimum) {
        this.spacingAttributes.setSpaceBeforeOptimum(spaceBeforeOptimum);
    }

    public void setSpacingEnabled(boolean spacingEnabled) {
        this.spacingAttributes.setSpacingEnabled(spacingEnabled);
    }

    public void setStartIndent(String startIndent) {
        this.spacingAttributes.setStartIndent(startIndent);
    }

    public void setTextAlign(String textAlign) {
        this.lineAttributes.setTextAlign(textAlign);
    }

    public void setTextIndent(String textIndent) {
        this.spacingAttributes.setTextIndent(textIndent);
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setWrapOption(String wrapOption) {
        this.lineAttributes.setWrapOption(wrapOption);
    }

    public JLabel toJLabel() {
        if (this.label == null) {
            this.label = new JLabel(this.getText());
            this.label.setBorder(border);
            this.label.setOpaque(true);
            this.label.setHorizontalAlignment(2);
        }
        if (this.fixedSize != null) {
            this.label.setPreferredSize(this.fixedSize);
            this.label.setMaximumSize(this.fixedSize);
            this.label.setMinimumSize(this.fixedSize);
            this.label.setSize(this.fixedSize);
        } else {
            this.calculateDimension(this.label, this.fontAttributes.getFont());
        }
        return this.label;
    }

    private void calculateDimension(JLabel label, Font font) {
        Graphics g = label.getGraphics();
        if (font == null) {
            return;
        }
        Dimension dimension = new Dimension(200, 48);
        if (g != null) {
            FontMetrics fm = g.getFontMetrics(font);
            dimension.height = fm.getHeight() + 6;
        }
        label.setPreferredSize(dimension);
        label.setMaximumSize(dimension);
        label.setMinimumSize(dimension);
        label.setSize(dimension);
    }

    public String getText() {
        return this.text;
    }

    private void setText(String text) {
        this.text = text;
    }

    public void autoEnable() {
        this.fontAttributes.autoEnable();
        this.spacingAttributes.autoEnable();
        this.frameAttributes.autoEnable();
        this.lineAttributes.autoEnable();
    }
}

