/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.filter;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.service.FileServices;

public class RegexpFileFilter
extends FileFilter {
    private static Log logger = LogFactory.getLog(RegexpFileFilter.class);
    private final String description;
    private final String regexp;

    public RegexpFileFilter(String regexp, String description) {
        if (regexp == null) {
            throw new IllegalArgumentException("The argument regexp must not be null!");
        }
        if (description == null) {
            throw new IllegalArgumentException("The argument description must not be null!");
        }
        this.regexp = regexp;
        this.description = description;
        if (!regexp.startsWith("^")) {
            regexp = "^.*" + regexp;
        }
        if (!regexp.endsWith("$")) {
            regexp = regexp + ".*$";
        }
    }

    @Override
    public boolean accept(File file) {
        logger.debug((Object)("file=" + file));
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            return true;
        }
        String ext = FileServices.getExtension(file.getName());
        if (ext == null || ext.length() == 0) {
            return false;
        }
        ext = ext.trim();
        if (!(ext = ext.toLowerCase()).startsWith(".")) {
            ext = "." + ext;
        }
        return ext.matches(this.regexp);
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

