/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.filter;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.service.FileServices;
import org.dbdoclet.service.StringServices;

public class ExtensionFileFilter
extends FileFilter {
    private static Log logger = LogFactory.getLog(ExtensionFileFilter.class);
    private String description;
    private String[] extensions;

    public ExtensionFileFilter(String extension) {
        if (extension == null) {
            throw new IllegalArgumentException("The argument extension must not be null!");
        }
        String[] extensions = new String[]{extension};
        this.init(extensions, extension);
    }

    public ExtensionFileFilter(String extension, String description) {
        if (extension == null) {
            throw new IllegalArgumentException("The argument extension must not be null!");
        }
        if (description == null) {
            throw new IllegalArgumentException("The argument description must not be null!");
        }
        String[] extensions = new String[]{extension};
        this.init(extensions, extension);
    }

    public ExtensionFileFilter(String[] extensions, String description) {
        if (description == null) {
            throw new IllegalArgumentException("The argument description must not be null!");
        }
        if (extensions == null || extensions.length == 0) {
            throw new IllegalArgumentException("The argument extension must not be null or empty!");
        }
        this.init(extensions, description);
    }

    private void init(String[] extensions, String description) {
        for (int i = 0; i < extensions.length; ++i) {
            extensions[i] = extensions[i].trim();
            extensions[i] = StringServices.cutPrefix(extensions[i], ".");
            extensions[i] = extensions[i].toLowerCase();
        }
        this.description = description;
        this.extensions = extensions;
    }

    @Override
    public boolean accept(File file) {
        logger.debug((Object)("file=" + file));
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            return true;
        }
        String ext = FileServices.getExtension(file.getName());
        if (ext == null || ext.length() == 0) {
            return false;
        }
        ext = ext.trim();
        ext = StringServices.cutPrefix(ext, ".");
        ext = ext.toLowerCase();
        for (int i = 0; i < this.extensions.length; ++i) {
            if (!ext.equals(this.extensions[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

