/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.filter;

import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;

public class BlurFilter {
    public static BufferedImage boxBlur(BufferedImage image, int radius) {
        if (radius < 1) {
            throw new IllegalArgumentException("Radius must be >= 1");
        }
        int size = radius * radius;
        float[] data = new float[size];
        for (int i = 0; i < data.length; ++i) {
            data[i] = 1.0f / new Float(data.length).floatValue();
        }
        Kernel kernel = new Kernel(radius, radius, data);
        ConvolveOp blurFilter = new ConvolveOp(kernel, 1, null);
        return blurFilter.filter(image, null);
    }

    public static BufferedImage gaussianBlur(BufferedImage image, int radius) {
        int r = (int)Math.ceil(radius);
        int rows = r * 2 + 1;
        float[] matrix = new float[rows];
        float sigma = radius / 3;
        float sigma22 = 2.0f * sigma * sigma;
        float sigmaPi2 = (float)(Math.PI * 2 * (double)sigma);
        float sqrtSigmaPi2 = (float)Math.sqrt(sigmaPi2);
        float radius2 = radius * radius;
        float total = 0.0f;
        int index = 0;
        for (int row = -r; row <= r; ++row) {
            float distance = row * row;
            matrix[index] = distance > radius2 ? 0.0f : (float)Math.exp(-distance / sigma22) / sqrtSigmaPi2;
            total += matrix[index];
            ++index;
        }
        int i = 0;
        while (i < rows) {
            int n = i++;
            matrix[n] = matrix[n] / total;
        }
        Kernel kernelVertical = new Kernel(rows, 1, matrix);
        Kernel kernelHorizontal = new Kernel(1, rows, matrix);
        ConvolveOp blurFilter = new ConvolveOp(kernelVertical, 1, null);
        image = blurFilter.filter(image, null);
        blurFilter = new ConvolveOp(kernelHorizontal, 1, null);
        image = blurFilter.filter(image, null);
        return image;
    }
}

