/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog.settings.jdk;

import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.jive.dialog.ErrorBox;
import org.dbdoclet.service.FileServices;
import org.dbdoclet.service.JvmServices;
import org.dbdoclet.service.ResourceServices;

public class JdkChooser
extends JFileChooser {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(JdkChooser.class);
    public ResourceBundle res;

    public JdkChooser(File dir, ResourceBundle res) {
        super(dir);
        this.res = res;
    }

    @Override
    public void approveSelection() {
        File dir = this.getSelectedFile();
        String path = FileServices.appendPath(dir, "bin");
        File binDir = new File(path);
        path = FileServices.appendPath(dir, "lib");
        File libDir = new File(path);
        path = FileServices.appendPath(dir, "jre");
        File jreDir = new File(path);
        path = FileServices.appendPath(dir, "bin");
        path = JvmServices.isWindows() ? FileServices.appendFileName(binDir, "javadoc.exe") : FileServices.appendFileName(binDir, "javadoc");
        File javadocFile = new File(path);
        if (!(binDir.exists() && libDir.exists() && jreDir.exists() && javadocFile.exists())) {
            String msg = MessageFormat.format(ResourceServices.getString(this.res, "C_ERROR_NO_JAVA_HOME"), dir.getAbsolutePath());
            ErrorBox.show(ResourceServices.getString(this.res, "C_ERROR"), msg);
            logger.error((Object)("Directory " + dir.getAbsolutePath() + " seems not to be a JDK home.\n" + " bin (" + binDir.getAbsolutePath() + ", " + binDir.exists() + ")\n" + " lib (" + libDir.getAbsolutePath() + ", " + libDir.exists() + ")\n" + " jre (" + jreDir.getAbsolutePath() + ", " + jreDir.exists() + ")\n" + " javadoc (" + javadocFile.getAbsolutePath() + "," + javadocFile.exists() + ")"));
            return;
        }
        logger.debug((Object)("approve selection: " + dir));
        super.approveSelection();
    }
}

