/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog.settings;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.dbdoclet.Identifier;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.dialog.settings.AbstractSettingsPanel;
import org.dbdoclet.jive.dialog.settings.ColumnData;
import org.dbdoclet.jive.dialog.settings.PathData;
import org.dbdoclet.jive.dialog.settings.PathTableData;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.service.ResourceServices;
import org.dbdoclet.service.StringServices;

public class PathsPanel
extends AbstractSettingsPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JiveFactory wm;
    private ResourceBundle res;
    private JButton editButton;
    private JButton standardButton;
    private JTable table;

    public PathsPanel(PathTableData data) {
        if (data == null) {
            throw new IllegalArgumentException("The argument data must not be null!");
        }
        this.wm = JiveFactory.getInstance();
        this.res = this.wm.getResourceBundle();
        this.setName("settings.panel.repositories");
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.table = this.wm.createTable(new Identifier("paths"));
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.setModel(data);
        this.table.addMouseListener(new PathsPanelMouseListener());
        this.table.setSelectionMode(0);
        ColumnData[] columns = data.getColumnData();
        for (int i = 0; i < data.getColumnCount(); ++i) {
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setHorizontalAlignment(columns[i].alignment);
            TableColumn tableColumn = new TableColumn(i, columns[i].width, renderer, null);
            this.table.addColumn(tableColumn);
        }
        JTableHeader header = this.table.getTableHeader();
        header.setUpdateTableInRealTime(false);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().setBackground(this.table.getBackground());
        scrollPane.getViewport().add(this.table);
        this.add((Component)scrollPane, gbc);
        GridPanel buttonPanel = new GridPanel();
        this.editButton = this.wm.createButton(new Identifier("edit"), ResourceServices.getString(this.res, "C_EDIT"));
        this.editButton.setActionCommand("edit");
        this.editButton.addActionListener(this);
        buttonPanel.addComponent(this.editButton);
        this.standardButton = this.wm.createButton(new Identifier("standard"), ResourceServices.getString(this.res, "C_STANDARD"));
        this.standardButton.setActionCommand("standard");
        this.standardButton.addActionListener(this);
        buttonPanel.addComponent(this.standardButton);
        gbc.fill = 2;
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)buttonPanel, gbc);
    }

    @Override
    public String getNamespace() {
        return null;
    }

    @Override
    public Properties getProperties() {
        if (this.table == null) {
            throw new IllegalStateException("The field table must not be null!");
        }
        PathTableData model = (PathTableData)this.table.getModel();
        Properties properties = new Properties();
        for (int i = 0; i < model.getRowCount(); ++i) {
            PathData entry = model.getEntry(i);
            properties.put(entry.getKey(), StringServices.replace(entry.getFilePath(), File.separator, "/"));
        }
        return properties;
    }

    @Override
    public void setProperties(Properties properties) {
        if (this.table == null) {
            throw new IllegalStateException("The field table must not be null!");
        }
        if (properties == null) {
            throw new IllegalArgumentException("The argument properties must not be null!");
        }
        PathTableData model = (PathTableData)this.table.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            PathData entry = model.getEntry(i);
            String property = properties.getProperty(entry.getKey());
            if (property == null) continue;
            entry.setFile(new File(property));
        }
        model.reload();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.table == null) {
            return;
        }
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow != -1) {
            if (event.getSource() == this.editButton) {
                this.editRow(selectedRow);
            }
            if (event.getSource() == this.standardButton) {
                PathTableData model = (PathTableData)this.table.getModel();
                PathData entry = model.getEntry(selectedRow);
                entry.setFile(entry.getStandard());
                model.reloadRow(selectedRow);
            }
        }
    }

    private void editRow(int rowIndex) {
        if (this.table == null) {
            throw new IllegalStateException("The field table must not be null!");
        }
        if (rowIndex < 0 || rowIndex >= this.table.getRowCount()) {
            return;
        }
        PathTableData model = (PathTableData)this.table.getModel();
        PathData entry = model.getEntry(rowIndex);
        File file = entry.getFile();
        JFileChooser fc = new JFileChooser(file);
        fc.setFileSelectionMode(1);
        int rc = fc.showOpenDialog(this);
        if (rc == 0) {
            file = fc.getSelectedFile();
            entry.setFile(file);
            model.reloadRow(rowIndex);
        }
    }

    class PathsPanelMouseListener
    extends MouseAdapter {
        PathsPanelMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            int rowIndex;
            if (event.getClickCount() == 2 && (rowIndex = PathsPanel.this.table.rowAtPoint(event.getPoint())) != -1) {
                PathsPanel.this.editRow(rowIndex);
            }
        }
    }
}

