/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog.settings;

import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.dialog.settings.ColumnData;
import org.dbdoclet.jive.dialog.settings.PathData;
import org.dbdoclet.service.ResourceServices;

public class PathTableData
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private JiveFactory wm = JiveFactory.getInstance();
    private ResourceBundle res = this.wm.getResourceBundle();
    private ColumnData[] columns = new ColumnData[2];
    private Vector<PathData> vector;

    public PathTableData() {
        this.columns[0] = new ColumnData(ResourceServices.getString(this.res, "C_NAME"), 100, 2);
        this.columns[1] = new ColumnData(ResourceServices.getString(this.res, "C_PATH"), 100, 2);
        this.vector = new Vector();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    public ColumnData[] getColumnData() {
        return this.columns;
    }

    @Override
    public String getColumnName(int index) {
        String title = this.columns[index].title;
        return title;
    }

    public void addLabeledComponent(PathData data) {
        this.vector.add(data);
    }

    public PathData getEntry(int index) {
        PathData data = this.vector.get(index);
        return data;
    }

    public void reloadRow(int index) {
        this.fireTableRowsUpdated(index, index);
    }

    public void reload() {
        this.fireTableRowsUpdated(0, this.vector.size() - 1);
    }

    @Override
    public int getRowCount() {
        if (this.vector == null) {
            return 0;
        }
        return this.vector.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < 0 || row >= this.getRowCount()) {
            return "";
        }
        PathData data = this.vector.elementAt(row);
        switch (column) {
            case 0: {
                return data.getLabel();
            }
            case 1: {
                return data.getFile();
            }
        }
        return "";
    }
}

