/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog.settings;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.dbdoclet.jive.Anchor;
import org.dbdoclet.jive.Fill;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.dialog.settings.AbstractSettingsPanel;
import org.dbdoclet.jive.model.LabelItem;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.service.ResourceServices;

public class LanguageFilterPanel
extends AbstractSettingsPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private TreeMap<String, Locale> selectedLocaleMap;
    private JList<LabelItem> languageListBox;
    private JList<LabelItem> selectedListBox;
    private ResourceBundle res;
    private JiveFactory wm;
    private Locale ctxLocale;

    public LanguageFilterPanel(Locale ctxLocale) {
        if (ctxLocale == null) {
            throw new IllegalArgumentException("The argument ctxLocale must not be null!");
        }
        this.ctxLocale = ctxLocale;
        this.wm = JiveFactory.getInstance();
        this.res = this.wm.getResourceBundle();
        this.setName("settings.panel.language-filter");
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.selectedLocaleMap = new TreeMap();
        this.init();
    }

    public LanguageFilterPanel(Locale ctxLocale, File confFile) {
        this(ctxLocale);
        if (confFile == null) {
            throw new IllegalArgumentException("The argument confFile must not be null!");
        }
    }

    @Override
    public String getNamespace() {
        return "language.";
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        Iterator<String> iterator = this.selectedLocaleMap.keySet().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            String key = iterator.next();
            Locale locale = this.selectedLocaleMap.get(key);
            properties.setProperty("language.l" + ++index, locale.getLanguage());
        }
        return properties;
    }

    @Override
    public void setProperties(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("The argument properties must not be null!");
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.selectedListBox.getModel();
        int index = 1;
        String lang = properties.getProperty("language.l" + index++);
        while (lang != null) {
            Locale locale = new Locale(lang);
            if (this.selectedLocaleMap.get(locale.getDisplayLanguage(this.ctxLocale)) == null) {
                this.selectedLocaleMap.put(locale.getDisplayLanguage(this.ctxLocale), locale);
                model.addElement(new LabelItem(locale.getDisplayLanguage(this.ctxLocale), locale));
            }
            lang = properties.getProperty("language.l" + index++);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd == null) {
            return;
        }
        if (cmd.equals("add")) {
            List<LabelItem> itemList = this.languageListBox.getSelectedValuesList();
            if (itemList != null) {
                Locale locale;
                for (LabelItem item2 : itemList) {
                    locale = (Locale)item2.getValue();
                    if (this.selectedLocaleMap.get(locale.getDisplayLanguage(this.ctxLocale)) != null) continue;
                    this.selectedLocaleMap.put(locale.getDisplayLanguage(this.ctxLocale), locale);
                }
                DefaultComboBoxModel model = (DefaultComboBoxModel)this.selectedListBox.getModel();
                model.removeAllElements();
                for (String label : this.selectedLocaleMap.keySet()) {
                    locale = this.selectedLocaleMap.get(label);
                    model.addElement(new LabelItem(label, locale));
                }
            }
            this.languageListBox.clearSelection();
        }
        if (cmd.equals("remove")) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.selectedListBox.getModel();
            this.selectedListBox.getSelectedValuesList().forEach(item -> {
                Locale locale = (Locale)item.getValue();
                if (this.selectedLocaleMap.get(locale.getDisplayLanguage(this.ctxLocale)) != null) {
                    this.selectedLocaleMap.remove(locale.getDisplayLanguage(this.ctxLocale));
                }
                model.removeElement(item);
            });
        }
    }

    private void init() {
        Locale locale;
        String[] isoLanguageList = Locale.getISOLanguages();
        Locale[] isoLocaleList = new Locale[isoLanguageList.length];
        for (int i = 0; i < isoLanguageList.length; ++i) {
            isoLocaleList[i] = new Locale(isoLanguageList[i]);
        }
        DefaultComboBoxModel<LabelItem> model = new DefaultComboBoxModel<LabelItem>();
        TreeMap<String, Locale> localeMap = new TreeMap<String, Locale>();
        for (int i = 0; i < isoLocaleList.length; ++i) {
            String language = isoLocaleList[i].getLanguage();
            String text = isoLocaleList[i].getDisplayLanguage(this.ctxLocale);
            locale = (Locale)localeMap.get(text);
            if (locale != null) continue;
            localeMap.put(text, new Locale(language));
        }
        for (String name : localeMap.keySet()) {
            locale = (Locale)localeMap.get(name);
            model.addElement(new LabelItem(locale.getDisplayLanguage(this.ctxLocale), locale));
        }
        this.languageListBox = new JList();
        this.languageListBox.setModel(model);
        model = new DefaultComboBoxModel();
        for (String name : this.selectedLocaleMap.keySet()) {
            locale = this.selectedLocaleMap.get(name);
            model.addElement(new LabelItem(locale.getDisplayLanguage(this.ctxLocale), locale));
        }
        this.selectedListBox = new JList();
        this.selectedListBox.setModel(model);
        GridPanel selectButtonPanel = new GridPanel();
        JButton addButton = this.wm.createButton(null, ResourceServices.getString(this.res, "C_ADD"));
        addButton.addActionListener(this);
        addButton.setActionCommand("add");
        selectButtonPanel.addComponent((JComponent)addButton, Anchor.NORTHWEST, Fill.HORIZONTAL);
        selectButtonPanel.incrRow();
        JButton removeButton = this.wm.createButton(null, ResourceServices.getString(this.res, "C_REMOVE"));
        removeButton.addActionListener(this);
        removeButton.setActionCommand("remove");
        selectButtonPanel.addComponent((JComponent)removeButton, Anchor.NORTHWEST, Fill.HORIZONTAL);
        this.addComponent((JComponent)new JScrollPane(this.languageListBox), Anchor.NORTHWEST, Fill.BOTH);
        this.addComponent((JComponent)selectButtonPanel, Anchor.NORTHWEST, Fill.VERTICAL);
        this.addComponent((JComponent)new JScrollPane(this.selectedListBox), Anchor.NORTHWEST, Fill.BOTH);
    }
}

