/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog.settings;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.dialog.settings.AbstractSettingsPanel;
import org.dbdoclet.jive.dialog.settings.ColumnData;
import org.dbdoclet.jive.dialog.settings.jdk.JdkChooser;
import org.dbdoclet.jive.dialog.settings.jdk.JdkData;
import org.dbdoclet.jive.dialog.settings.jdk.JdkTableModel;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.service.FileServices;
import org.dbdoclet.service.ResourceServices;
import org.dbdoclet.service.StringServices;

public class JdkPanel
extends AbstractSettingsPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(JdkPanel.class);
    private final JiveFactory wm = JiveFactory.getInstance();
    private final ResourceBundle res = this.wm.getResourceBundle();
    private final JButton newButton;
    private final JButton deleteButton;
    private final JTable table;
    private final JdkTableModel model;

    public JdkPanel() {
        this.setName("settings.panel.jdk");
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.model = new JdkTableModel();
        this.table = this.wm.createTable(null);
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.setModel(this.model);
        this.table.setSelectionMode(0);
        ColumnData[] columns = this.model.getColumnData();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setHorizontalAlignment(columns[i].alignment);
            TableColumn tableColumn = new TableColumn(i, columns[i].width, renderer, null);
            this.table.addColumn(tableColumn);
        }
        JTableHeader header = this.table.getTableHeader();
        header.setUpdateTableInRealTime(false);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().setBackground(this.table.getBackground());
        scrollPane.getViewport().add(this.table);
        this.add((Component)scrollPane, gbc);
        GridPanel buttonPanel = new GridPanel();
        this.newButton = this.wm.createButton(null, ResourceServices.getString(this.res, "C_NEW"));
        this.newButton.setActionCommand("new");
        this.newButton.addActionListener(this);
        buttonPanel.addComponent(this.newButton);
        this.deleteButton = this.wm.createButton(null, ResourceServices.getString(this.res, "C_DELETE"));
        this.deleteButton.setActionCommand("delete");
        this.deleteButton.addActionListener(this);
        buttonPanel.addComponent(this.deleteButton);
        gbc.fill = 2;
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)buttonPanel, gbc);
    }

    @Override
    public String getNamespace() {
        return "java.jdk.";
    }

    @Override
    public Properties getProperties() {
        if (this.table == null) {
            throw new IllegalStateException("The field table must not be null!");
        }
        JdkTableModel model = (JdkTableModel)this.table.getModel();
        Properties properties = new Properties();
        for (int i = 0; i < model.getRowCount(); ++i) {
            JdkData entry = model.getEntry(i);
            properties.put("java.jdk." + entry.getLabel(), FileServices.normalizePath(entry.getJavaHomePath()));
        }
        return properties;
    }

    @Override
    public void setProperties(Properties properties) {
        if (this.table == null) {
            throw new IllegalStateException("The field table must not be null!");
        }
        if (properties == null) {
            throw new IllegalArgumentException("The argument properties must not be null!");
        }
        JdkTableModel model = (JdkTableModel)this.table.getModel();
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith("java.jdk.")) continue;
            String value = properties.getProperty(name);
            name = StringServices.cutPrefix(name, "java.jdk.");
            JdkData data = new JdkData(name, new File(value));
            model.addLabeledComponent(data);
        }
        model.reload();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int selectedRow;
        if (this.table == null) {
            return;
        }
        String cmd = event.getActionCommand();
        if (cmd.equals("new")) {
            this.addJdk();
            return;
        }
        if (cmd.equals("delete") && (selectedRow = this.table.getSelectedRow()) != -1) {
            this.removeJdk(selectedRow);
        }
    }

    private void addJdk() {
        if (this.table == null) {
            throw new IllegalStateException("The field table must not be null!");
        }
        JdkTableModel model = (JdkTableModel)this.table.getModel();
        JdkChooser fc = new JdkChooser(new File("/"), this.res);
        fc.setFileSelectionMode(1);
        int rc = fc.showOpenDialog(this);
        if (rc == 0) {
            File file = fc.getSelectedFile();
            logger.debug((Object)("file=" + file));
            JdkData jdkData = new JdkData(file.getName(), file);
            model.addLabeledComponent(jdkData);
        }
    }

    private void removeJdk(int row) {
        if (this.table == null) {
            throw new IllegalStateException("The field table must not be null!");
        }
        JdkTableModel model = (JdkTableModel)this.table.getModel();
        model.removeEntry(row);
    }
}

