/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog.property;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.dbdoclet.jive.dialog.property.AbstractProperty;
import org.dbdoclet.jive.model.LabelItem;

public class SelectProperty
extends AbstractProperty
implements ActionListener {
    private ArrayList<LabelItem> itemList;
    private JComboBox<LabelItem> comboBox;
    private boolean editable;

    public SelectProperty(String label, ArrayList<LabelItem> itemList, String selected) {
        super(label, selected);
        this.itemList = itemList;
    }

    public SelectProperty(String label, String[] items, String selected) {
        super(label, selected);
        this.itemList = new ArrayList();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                this.itemList.add(new LabelItem(items[i], items[i]));
            }
        }
    }

    @Override
    public Component getEditor(Object value) {
        if (!this.isEnabled()) {
            return new JLabel("");
        }
        this.comboBox = new JComboBox<LabelItem>(new Vector<LabelItem>(this.getItemList()));
        this.comboBox.setSelectedItem(this.getSelectedItem());
        this.comboBox.setEditable(this.isEditable());
        this.comboBox.addActionListener(this);
        if (this.getAction() != null) {
            this.comboBox.setAction(this.getAction());
        }
        return this.comboBox;
    }

    @Override
    public Object getEditorValue() {
        if (this.comboBox == null) {
            return null;
        }
        Object obj = this.comboBox.getSelectedItem();
        if (obj == null) {
            return null;
        }
        if (obj instanceof LabelItem) {
            LabelItem item = (LabelItem)this.comboBox.getSelectedItem();
            return item.getValue();
        }
        return obj;
    }

    public String getItemLabel() {
        LabelItem item = this.getSelectedItem();
        if (item != null) {
            return item.getLabel();
        }
        return "";
    }

    public ArrayList<LabelItem> getItemList() {
        return this.itemList;
    }

    @Override
    public Component getRenderer(Object value) {
        JLabel label = new JLabel();
        label.setFont(this.getPlainFont());
        label.setText(this.getItemLabel());
        return label;
    }

    public LabelItem getSelectedItem() {
        String selected = (String)super.getValue();
        for (LabelItem item : this.itemList) {
            if (!item.equals(selected)) continue;
            return item;
        }
        return null;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public Object getValue() {
        LabelItem item = this.getSelectedItem();
        if (item != null) {
            return item.getValue();
        }
        return "";
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setItemList(ArrayList<LabelItem> itemList) {
        this.itemList = itemList;
    }

    private boolean isEditable() {
        return this.editable;
    }

    public void setItemList(String[] items) {
        this.itemList = new ArrayList();
        for (String item : items) {
            this.itemList.add(new LabelItem(item, item));
        }
        this.getPanel().update();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComboBox comboBox = (JComboBox)e.getSource();
        Object obj = comboBox.getSelectedItem();
        if (obj instanceof String) {
            LabelItem item = new LabelItem((String)obj, obj);
            if (!this.itemList.contains(item)) {
                this.itemList.add(item);
            }
            this.setValue(item.getValue());
        }
        if (obj instanceof LabelItem) {
            this.setValue(((LabelItem)obj).getValue());
        }
    }
}

