/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog.property;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.dbdoclet.jive.dialog.property.AbstractProperty;
import org.dbdoclet.jive.dialog.property.ListCheckBoxCellRenderer;
import org.dbdoclet.jive.model.LabelItem;

public class ListProperty
extends AbstractProperty
implements ActionListener {
    private ArrayList<LabelItem> itemList;
    private JList<LabelItem> list;
    private boolean editable;

    public ListProperty(String label, ArrayList<LabelItem> itemList, String selected) {
        super(label, selected);
        this.itemList = itemList;
    }

    public ListProperty(String label, String[] items, String selected) {
        super(label, selected);
        this.itemList = new ArrayList();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                this.itemList.add(new LabelItem(items[i], items[i]));
            }
        }
    }

    @Override
    public Component getEditor(Object value) {
        if (!this.isEnabled()) {
            return new JLabel("");
        }
        this.list = new JList<LabelItem>(new Vector<LabelItem>(this.getItemList()));
        this.list.setCellRenderer(new ListCheckBoxCellRenderer());
        return this.list;
    }

    @Override
    public Object getEditorValue() {
        if (this.list == null) {
            return null;
        }
        return null;
    }

    public String getItemLabel() {
        LabelItem item = this.getSelectedItem();
        if (item != null) {
            return item.getLabel();
        }
        return "";
    }

    public ArrayList<LabelItem> getItemList() {
        return this.itemList;
    }

    @Override
    public Component getRenderer(Object value) {
        JList<LabelItem> list = new JList<LabelItem>(new Vector<LabelItem>(this.getItemList()));
        list.setVisibleRowCount(this.getItemList().size());
        list.setCellRenderer(new ListCheckBoxCellRenderer());
        return new JScrollPane(list);
    }

    public LabelItem getSelectedItem() {
        String selected = (String)super.getValue();
        for (LabelItem item : this.itemList) {
            if (!item.equals(selected)) continue;
            return item;
        }
        return null;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public Object getValue() {
        LabelItem item = this.getSelectedItem();
        if (item != null) {
            return item.getValue();
        }
        return "";
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setItemList(ArrayList<LabelItem> itemList) {
        this.itemList = itemList;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setItemList(String[] items) {
        this.itemList = new ArrayList();
        for (String item : items) {
            this.itemList.add(new LabelItem(item, item));
        }
        this.getPanel().update();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComboBox comboBox = (JComboBox)e.getSource();
        Object obj = comboBox.getSelectedItem();
        if (obj instanceof String) {
            LabelItem item = new LabelItem((String)obj, obj);
            if (!this.itemList.contains(item)) {
                this.itemList.add(item);
            }
            this.setValue(item.getValue());
        }
        if (obj instanceof LabelItem) {
            this.setValue(((LabelItem)obj).getValue());
        }
    }
}

