/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog.property;

import java.awt.Component;
import javax.swing.JLabel;
import org.dbdoclet.jive.dialog.property.AbstractProperty;
import org.dbdoclet.jive.widget.NumberTextField;

public class IntegerProperty
extends AbstractProperty {
    private NumberTextField numberTextField;
    private final int cols;

    public IntegerProperty(String label, int value, int cols) {
        super(label, new Integer(value));
        this.cols = cols;
    }

    @Override
    public int getType() {
        return 8;
    }

    public Integer getInteger() {
        return (Integer)this.getValue();
    }

    @Override
    public Component getRenderer(Object value) {
        JLabel label = new JLabel();
        label.setFont(this.getPlainFont());
        if (value != null) {
            label.setText(value.toString());
        }
        return label;
    }

    @Override
    public Component getEditor(Object value) {
        this.numberTextField = new NumberTextField(this.cols);
        if (value != null) {
            this.numberTextField.setText(value.toString());
        }
        if (this.getAction() != null) {
            this.numberTextField.setAction(this.getAction());
        }
        return this.numberTextField;
    }

    @Override
    public Object getEditorValue() {
        if (this.numberTextField == null) {
            throw new IllegalStateException("The field checkBox must not be null!");
        }
        return this.numberTextField.getText();
    }
}

