/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog.property;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import org.dbdoclet.jive.dialog.ImageChooser;
import org.dbdoclet.jive.dialog.property.AbstractProperty;
import org.dbdoclet.service.FileServices;
import org.dbdoclet.service.StringServices;
import org.dbdoclet.xiphias.ImageServices;

public class ImageProperty
extends AbstractProperty {
    private File baseDir;
    private JFileChooser chooser;
    private JLabel label;
    private String[] supportedExtensions = new String[]{"gif", "jpg", "png"};

    public ImageProperty(String label, File value) {
        super(label, value);
        this.chooser = new ImageChooser();
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    @Override
    public Component getEditor(Object value) {
        int rc;
        this.label = new JLabel();
        if (this.getBaseDir() != null) {
            this.chooser.setCurrentDirectory(this.getBaseDir());
        }
        this.label.setFont(this.getPlainFont());
        this.label.setName("imageType://" + this.getImagePath());
        this.label.setEnabled(this.isEnabled());
        if (this.isRenderable()) {
            ImageIcon icon = ImageServices.getScaledIcon(new ImageIcon(this.getRenderableImagePath()), -1, 20);
            this.label.setText("");
            this.label.setIcon(icon);
            this.label.setHorizontalAlignment(0);
        } else {
            this.label.setText(this.getImagePath());
            this.label.setIcon(null);
        }
        if (this.isEnabled() && (rc = this.chooser.showOpenDialog(this.getPanel())) == 0) {
            File imageFile = this.chooser.getSelectedFile();
            if (this.isRenderable(imageFile)) {
                ImageIcon icon = ImageServices.getScaledIcon(new ImageIcon(this.getRenderableImagePath(imageFile)), -1, 20);
                this.label.setText("");
                this.label.setIcon(icon);
                this.label.setHorizontalAlignment(0);
            } else {
                this.label.setText(imageFile.getPath());
                this.label.setIcon(null);
            }
            if (this.getAction() != null) {
                this.getAction().actionPerformed(new ActionEvent(this, 1001, ""));
            }
            this.label.setName("imageType://" + imageFile.getAbsolutePath());
        }
        return this.label;
    }

    @Override
    public Object getEditorValue() {
        if (this.label == null) {
            throw new IllegalStateException("The field label must not be null!");
        }
        String name = this.label.getName();
        if (name != null && name.startsWith("imageType://")) {
            return StringServices.cutPrefix(name, "imageType://");
        }
        return "";
    }

    public File getImageFile() {
        Object obj = this.getValue();
        if (obj == null) {
            return null;
        }
        if (obj instanceof File) {
            return (File)obj;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            if (str.trim().length() == 0) {
                return null;
            }
            return new File(str);
        }
        throw new IllegalStateException("The field value must be of type File or String, not " + obj.getClass().getName() + "!");
    }

    public String getImagePath() {
        File imageFile = this.getImageFile();
        if (imageFile != null) {
            return imageFile.getAbsolutePath();
        }
        return "";
    }

    public File getRenderableImageFile(File imageFile) {
        String ext = FileServices.getExtension(imageFile.getAbsolutePath()).toLowerCase();
        if (Arrays.asList(this.supportedExtensions).contains(ext)) {
            return imageFile;
        }
        String path = FileServices.getFileBase(imageFile);
        for (int i = 0; i < this.supportedExtensions.length; ++i) {
            String renderableImagePath = path + "." + this.supportedExtensions[i];
            File renderableImageFile = new File(renderableImagePath);
            if (!renderableImageFile.exists()) continue;
            return renderableImageFile;
        }
        return null;
    }

    public String getRenderableImagePath() {
        return this.getRenderableImagePath(this.getImageFile());
    }

    public String getRenderableImagePath(File imageFile) {
        File file = this.getRenderableImageFile(imageFile);
        if (file != null && file.exists()) {
            return file.getAbsolutePath();
        }
        return "";
    }

    @Override
    public Component getRenderer(Object value) {
        File imageFile = this.getImageFile();
        JLabel label = new JLabel();
        label.setFont(this.getPlainFont());
        ImageIcon icon = null;
        if (this.isRenderable()) {
            if (imageFile != null && imageFile.exists()) {
                icon = ImageServices.getScaledIcon(new ImageIcon(this.getRenderableImagePath()), -1, 20);
            }
            label.setText("");
            if (icon != null) {
                label.setIcon(icon);
            }
        } else {
            label.setIcon(null);
            if (imageFile != null && imageFile.exists()) {
                label.setText(imageFile.getAbsolutePath());
            } else {
                label.setText("");
            }
        }
        return label;
    }

    @Override
    public int getType() {
        return 4;
    }

    public boolean isRenderable() {
        return this.isRenderable(this.getImageFile());
    }

    public boolean isRenderable(File imageFile) {
        if (imageFile == null || !imageFile.exists()) {
            return false;
        }
        return this.getRenderableImageFile(imageFile) != null;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setChooser(JFileChooser chooser) {
        if (chooser != null) {
            this.chooser = chooser;
        }
    }

    public JFileChooser getChooser() {
        return this.chooser;
    }
}

