/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog.property;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.filechooser.FileFilter;
import org.dbdoclet.jive.dialog.property.AbstractProperty;
import org.dbdoclet.service.StringServices;

public class FileProperty
extends AbstractProperty {
    private FileFilter fileFilter;
    private JLabel label;
    private File baseDir;

    public FileProperty(String label) {
        super(label, null);
    }

    public FileProperty(String label, File value) {
        super(label, value);
    }

    @Override
    public int getType() {
        return 7;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public String getFilePath() {
        File file = this.getFile();
        if (file != null) {
            return file.getAbsolutePath();
        }
        return "";
    }

    public File getFile() {
        Object obj = this.getValue();
        if (obj == null) {
            return null;
        }
        if (obj instanceof File) {
            return (File)obj;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            if (str.trim().length() == 0) {
                return null;
            }
            return new File(str);
        }
        throw new IllegalStateException("The field value must be of type File or String, not " + obj.getClass().getName() + "!");
    }

    @Override
    public Component getEditor(Object value) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(this.getFileFilter());
        File file = this.getBaseDir();
        if (file != null && file.exists()) {
            chooser.setCurrentDirectory(file);
        }
        if ((file = this.getFile()) != null && file.exists()) {
            chooser.setSelectedFile(this.getFile());
        }
        int rc = chooser.showOpenDialog(this.getPanel());
        this.label = new JLabel();
        this.label.setFont(this.getPlainFont());
        this.label.setText(this.getFilePath());
        this.label.setName("fileType://" + this.getFilePath());
        if (rc == 0) {
            file = chooser.getSelectedFile();
            this.label.setText(file.getAbsolutePath());
            this.label.setName("fileType://" + file.getAbsolutePath());
        }
        return this.label;
    }

    @Override
    public Object getEditorValue() {
        if (this.label == null) {
            throw new IllegalStateException("The field label must not be null!");
        }
        String name = this.label.getName();
        if (name != null && name.startsWith("fileType://")) {
            return StringServices.cutPrefix(name, "fileType://");
        }
        return "";
    }
}

