/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog.property;

import java.awt.Component;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.dialog.DateChooser;
import org.dbdoclet.jive.dialog.property.AbstractProperty;

public class DateProperty
extends AbstractProperty {
    private static final int LESS_OR_EQUAL_TODAY = 1;
    private int constraint;
    private DateChooser chooser;

    public DateProperty(String label, Date date) {
        super(label, date);
    }

    @Override
    public int getType() {
        return 5;
    }

    public Date getDate() {
        return (Date)this.getValue();
    }

    public String getDateAsText(Locale locale) {
        Date date = (Date)this.getValue();
        DateFormat df = DateFormat.getDateInstance(1, locale);
        return df.format(date);
    }

    public void setConstraint(int constraint) {
        this.constraint = constraint;
    }

    @Override
    public void setValue(Object value) {
        if (value == null || !(value instanceof Date)) {
            return;
        }
        Date date = (Date)value;
        Date now = new Date();
        if (this.constraint == 1 && date.after(now)) {
            return;
        }
        super.setValue(value);
    }

    @Override
    public Component getRenderer(Object value) {
        JiveFactory wm = JiveFactory.getInstance();
        ResourceBundle res = wm.getResourceBundle();
        JLabel label = new JLabel();
        label.setFont(this.getPlainFont());
        label.setText(this.getDateAsText(res.getLocale()));
        return label;
    }

    @Override
    public Component getEditor(Object value) {
        Date date = this.getDate();
        if (date == null) {
            date = new Date();
        }
        this.chooser = new DateChooser(date);
        return this.chooser;
    }

    @Override
    public Object getEditorValue() {
        if (this.chooser == null) {
            throw new IllegalStateException("The field chooser must not be null!");
        }
        Date date = this.chooser.getDate();
        return date;
    }
}

