/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog.property;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import org.dbdoclet.jive.dialog.property.AbstractProperty;

public class ColorProperty
extends AbstractProperty {
    private JLabel label;

    public ColorProperty(String label, Color color) {
        super(label, color);
    }

    @Override
    public int getType() {
        return 6;
    }

    public Color getColor() {
        return (Color)this.getValue();
    }

    @Override
    public void setValue(Object value) {
        if (value == null || !(value instanceof Color)) {
            return;
        }
        super.setValue(value);
    }

    @Override
    public Component getRenderer(Object value) {
        Color color = this.getColor();
        JLabel label = new JLabel();
        label.setFont(this.getPlainFont());
        label.setText("Color");
        label.setOpaque(true);
        label.setForeground(color);
        label.setBackground(color);
        return label;
    }

    @Override
    public Component getEditor(Object value) {
        Color color = this.getColor();
        this.label = new JLabel();
        this.label.setText("Color");
        this.label.setOpaque(true);
        this.label.setForeground(color);
        this.label.setBackground(color);
        this.label.setName("colorType://" + color.getRGB());
        Color newColor = JColorChooser.showDialog(this.getPanel(), "Choose Color", color);
        this.label.setForeground(newColor);
        this.label.setBackground(newColor);
        this.label.setName("colorType://" + newColor.getRGB());
        return this.label;
    }

    @Override
    public Object getEditorValue() {
        if (this.label == null) {
            throw new IllegalStateException("The field label must not be null!");
        }
        return this.label.getForeground();
    }
}

