/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog.property;

import java.awt.Component;
import javax.swing.JCheckBox;
import org.dbdoclet.jive.dialog.property.AbstractProperty;

public class BooleanProperty
extends AbstractProperty {
    private JCheckBox checkBox;

    public BooleanProperty(String label, boolean value) {
        super(label, new Boolean(value));
    }

    @Override
    public int getType() {
        return 1;
    }

    public Boolean getBoolean() {
        return (Boolean)this.getValue();
    }

    @Override
    public Component getRenderer(Object value) {
        if (value == null) {
            value = Boolean.FALSE;
        }
        if (!(value instanceof Boolean)) {
            throw new IllegalArgumentException("Parameter value must be of type Boolean!");
        }
        JCheckBox checkBox = new JCheckBox();
        checkBox.setSelected((Boolean)value);
        return checkBox;
    }

    @Override
    public Component getEditor(Object value) {
        if (!(value instanceof Boolean)) {
            throw new IllegalStateException("Invalid value " + value);
        }
        this.checkBox = new JCheckBox();
        this.checkBox.setSelected((Boolean)value);
        return this.checkBox;
    }

    @Override
    public Object getEditorValue() {
        if (this.checkBox == null) {
            throw new IllegalStateException("The field checkBox must not be null!");
        }
        if (this.checkBox.isSelected()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

