/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog.property;

import java.awt.Component;
import java.awt.Font;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.dbdoclet.jive.dialog.property.Property;
import org.dbdoclet.jive.widget.PropertyPanel;

public abstract class AbstractProperty
implements Property {
    private AbstractAction action;
    private boolean enabled = true;
    private JTextField entry;
    private String label;
    private PropertyPanel panel;
    private Font plainFont;
    private String toolTip;
    private Object value;

    public AbstractProperty(String label, Object value) {
        this(label, value, null);
    }

    public AbstractProperty(String label, Object value, AbstractAction action) {
        if (label == null) {
            throw new IllegalArgumentException("The parameter label must not be null!");
        }
        this.label = label;
        this.value = value;
        this.action = action;
        JLabel comp = new JLabel();
        this.plainFont = comp.getFont();
        this.plainFont = this.plainFont.deriveFont(0);
    }

    @Override
    public AbstractAction getAction() {
        return this.action;
    }

    @Override
    public Component getEditor(Object value) {
        this.entry = new JTextField();
        if (value != null) {
            this.entry.setText(value.toString());
        }
        if (this.action != null) {
            this.entry.setAction(this.action);
        }
        return this.entry;
    }

    @Override
    public Object getEditorValue() {
        if (this.entry == null) {
            throw new IllegalStateException("The field entry must not be null!");
        }
        return this.entry.getText();
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public PropertyPanel getPanel() {
        return this.panel;
    }

    public Font getPlainFont() {
        return this.plainFont;
    }

    @Override
    public Component getRenderer(Object value) {
        if (value == null) {
            value = "";
        }
        JLabel label = new JLabel();
        label.setFont(this.getPlainFont());
        label.setText(value.toString());
        return label;
    }

    @Override
    public String getToolTip() {
        if (this.toolTip == null) {
            this.toolTip = "";
        }
        return this.toolTip;
    }

    @Override
    public abstract int getType();

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setAction(AbstractAction action) {
        this.action = action;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.panel.update();
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void setPanel(PropertyPanel dialog) {
        this.panel = dialog;
    }

    @Override
    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
        this.panel.update();
    }
}

