/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog.imagechooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.dbdoclet.jive.dialog.ImageChooser;

public class ImagePreview
extends JComponent
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final int SIZE = 400;
    private ImageIcon image = null;
    private ImageIcon thumbnail = null;
    private File file = null;

    public ImagePreview(ImageChooser chooser) {
        this.setMinimumSize(new Dimension(410, 410));
        this.setPreferredSize(new Dimension(420, 420));
        this.setMaximumSize(new Dimension(430, 430));
        this.setBorder(BorderFactory.createBevelBorder(1));
        chooser.addPropertyChangeListener(this);
    }

    public int getImageWidth() {
        if (this.image != null) {
            return this.image.getIconWidth();
        }
        return 0;
    }

    public int getImageHeight() {
        if (this.image != null) {
            return this.image.getIconHeight();
        }
        return 0;
    }

    public void loadImage() {
        if (this.file == null) {
            this.image = null;
            this.thumbnail = null;
            return;
        }
        this.image = new ImageIcon(this.file.getPath());
        if (this.image != null) {
            this.thumbnail = this.image.getIconWidth() > 400 ? new ImageIcon(this.image.getImage().getScaledInstance(400, -1, 1)) : this.image;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        boolean update = false;
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            this.file = null;
            update = true;
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            this.file = (File)e.getNewValue();
            update = true;
        }
        if (update) {
            this.thumbnail = null;
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(Color.white);
        Rectangle visibleRect = this.getVisibleRect();
        g.clearRect(0, 0, visibleRect.width, visibleRect.height);
        if (this.thumbnail == null) {
            this.loadImage();
        }
        if (this.thumbnail != null) {
            int x = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
            int y = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
            if (y < 0) {
                y = 0;
            }
            if (x < 5) {
                x = 5;
            }
            this.thumbnail.paintIcon(this, g, x, y);
        }
    }
}

