/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.dbdoclet.FileAccessDeniedException;
import org.dbdoclet.jive.JiveConstants;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.dialog.DialogAction;
import org.dbdoclet.jive.dialog.ExceptionBox;
import org.dbdoclet.jive.dialog.InfoDialog;
import org.dbdoclet.service.ResourceServices;

public class WarningBox {
    public static DialogAction show(String warning, String msg) {
        return WarningBox.show(null, warning, msg);
    }

    public static DialogAction show(Window parent, String warning, String msg) {
        return WarningBox.show(parent, warning, msg, 1);
    }

    public static DialogAction show(Window parent, String warning, String msg, int buttonMask) {
        try {
            if (warning == null) {
                throw new IllegalArgumentException("The argument warning may not be null!");
            }
            if (msg == null) {
                throw new IllegalArgumentException("The argument msg may not be null!");
            }
            InfoDialog dlg = null;
            if (parent instanceof Frame) {
                dlg = new InfoDialog(parent, warning, msg, buttonMask);
            }
            if (parent instanceof Dialog) {
                dlg = new InfoDialog(parent, warning, msg, buttonMask);
            }
            if (dlg == null) {
                dlg = new InfoDialog((Window)null, warning, msg, buttonMask);
            }
            dlg.init();
            dlg.setGradient(JiveConstants.COLOUR_DARK_ORANGE, JiveConstants.COLOUR_DARK_ORANGE_4);
            dlg.pack();
            dlg.center(parent);
            dlg.setVisible(true);
            return dlg.getPerformedAction();
        }
        catch (Throwable oops) {
            oops.printStackTrace();
            JOptionPane.showMessageDialog(parent, msg, warning, 0);
            return DialogAction.NONE;
        }
    }

    public static DialogAction showWithCancel(Window parent, String warning, String msg) {
        try {
            if (warning == null) {
                throw new IllegalArgumentException("The argument warning may not be null!");
            }
            if (msg == null) {
                throw new IllegalArgumentException("The argument msg may not be null!");
            }
            InfoDialog dlg = null;
            if (parent instanceof Frame) {
                dlg = new InfoDialog(parent, warning, msg, 3);
            }
            if (parent instanceof Dialog) {
                dlg = new InfoDialog(parent, warning, msg, 3);
            }
            if (dlg == null) {
                dlg = new InfoDialog((Window)null, warning, msg, 3);
            }
            dlg.setSize(400, 500);
            dlg.pack();
            dlg.center(parent);
            dlg.setVisible(true);
            return dlg.getPerformedAction();
        }
        catch (Throwable oops) {
            oops.printStackTrace();
            JOptionPane.showMessageDialog(parent, msg, warning, 0);
            return DialogAction.NONE;
        }
    }

    public static DialogAction showYesNo(Window parent, String warning, String msg) {
        try {
            if (warning == null) {
                throw new IllegalArgumentException("The argument warning may not be null!");
            }
            if (msg == null) {
                throw new IllegalArgumentException("The argument msg may not be null!");
            }
            InfoDialog dlg = null;
            if (parent instanceof Frame) {
                dlg = new InfoDialog(parent, warning, msg, 1536);
            }
            if (parent instanceof Dialog) {
                dlg = new InfoDialog(parent, warning, msg, 1536);
            }
            if (dlg == null) {
                dlg = new InfoDialog((Window)null, warning, msg, 1536);
            }
            dlg.setSize(400, 500);
            dlg.pack();
            dlg.center(parent);
            dlg.setVisible(true);
            return dlg.getPerformedAction();
        }
        catch (Throwable oops) {
            oops.printStackTrace();
            JOptionPane.showMessageDialog(parent, msg, warning, 0);
            return DialogAction.NONE;
        }
    }

    public static void show(Throwable oops) {
        WarningBox.show(null, oops);
    }

    public static void show(Frame parent, Throwable oops) {
        JiveFactory wm = JiveFactory.getInstance();
        ResourceBundle res = wm.getResourceBundle();
        if (oops instanceof FileAccessDeniedException) {
            String msg = MessageFormat.format(ResourceServices.getString(res, "C_ERROR_FILE_ACCESS_DENIED"), ((FileAccessDeniedException)oops).getFile().getAbsolutePath());
            WarningBox.show(parent, ResourceServices.getString(res, "C_ERROR"), msg);
            return;
        }
        ExceptionBox ebox = new ExceptionBox(oops);
        ebox.setVisible(true);
        ebox.toFront();
    }
}

