/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog;

import java.awt.Dimension;
import java.awt.Frame;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JProgressBar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.jive.Anchor;
import org.dbdoclet.jive.Fill;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.dialog.DataDialog;
import org.dbdoclet.jive.text.TextServices;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.progress.ProgressEvent;
import org.dbdoclet.progress.ProgressVetoListener;
import org.dbdoclet.service.ResourceServices;
import org.dbdoclet.service.StringServices;

public class StepProgressDialog
extends DataDialog
implements ProgressVetoListener {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(StepProgressDialog.class);
    private ArrayList<ArrayList<ProgressEvent>> stepEventList;
    private DateFormat df;
    private JEditorPane info;
    private JProgressBar mainBar;
    private JProgressBar stepBar;
    private ResourceBundle res;
    private String title;
    private URL bgImgUrl;
    private JiveFactory wm;
    private int currentStep = 0;
    private int prepareCounter;
    private int progressMaximum = 1;
    private int progressValue;
    private int stepProgressMaximum = 1;
    private int stepProgressValue;
    private int stepCount = 1;
    private long progressStartTime = 0L;
    private long lastProgressEventTime = 0L;

    public StepProgressDialog(Frame parent, String title) {
        super(parent, title, false);
        this.init(parent);
    }

    public void setMainIndeterminate(boolean indeterminate) {
        this.mainBar.setIndeterminate(indeterminate);
        this.mainBar.setStringPainted(!indeterminate);
    }

    public void setText(String msg) {
        TextServices.setText(this.info, msg, this.bgImgUrl);
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    public ArrayList<ProgressEvent> getStepEventList(int step) {
        if (this.stepEventList == null) {
            throw new IllegalStateException("The field stepEventList must not be null!");
        }
        if (step < 0 || step >= this.stepEventList.size()) {
            return null;
        }
        return this.stepEventList.get(step);
    }

    public void setStepCount(int stepCount) {
        if (stepCount > 1) {
            this.stepCount = stepCount;
            for (int i = this.stepEventList.size(); i < stepCount; ++i) {
                this.stepEventList.add(new ArrayList());
            }
        }
    }

    public void nextStep() {
        logger.debug((Object)"nextStep");
        if (this.currentStep < this.stepCount) {
            ++this.currentStep;
            this.reset();
        }
    }

    public void reset() {
        logger.debug((Object)"reset");
        this.prepareCounter = 0;
        this.progressMaximum = 1;
        this.progressValue = 0;
        this.stepProgressMaximum = 1;
        this.stepProgressValue = 0;
        this.stepBar.setMaximum(100);
        this.stepBar.setValue(0);
        this.mainBar.setMaximum(this.stepCount);
        this.mainBar.setValue(this.currentStep);
    }

    @Override
    public boolean progress(ProgressEvent event) {
        StringBuffer buffer;
        long time = System.currentTimeMillis();
        int stage = event.getStage();
        if (stage == 1) {
            ++this.prepareCounter;
        }
        if (stage == 2 && event.getConsider()) {
            this.progressIncr();
        }
        if (time - this.lastProgressEventTime < 250L) {
            return true;
        }
        this.lastProgressEventTime = time;
        String action = event.getAction();
        if (action != null) {
            if ((action = action.trim()).startsWith("<html>")) {
                action = StringServices.cutPrefix(action, "<html>");
                action = StringServices.cutSuffix(action, "</html>");
            } else {
                action = "<p>" + StringServices.shorten(action, 80) + "</p>";
            }
        }
        event.getUserObject();
        if (stage == 1) {
            this.stepBar.setIndeterminate(true);
            this.stepBar.setStringPainted(false);
            buffer = new StringBuffer();
            buffer.append("<html><h3>");
            if (this.title == null) {
                buffer.append(ResourceServices.getString(this.res, "C_PREPARE"));
            } else {
                buffer.append(this.title);
            }
            buffer.append("</h3><table width='100%'><tr><th width='25%'></th><th width='25%'>");
            buffer.append(ResourceServices.getString(this.res, "C_START_TIME"));
            buffer.append("</th><th width='25%'>");
            buffer.append(ResourceServices.getString(this.res, "C_ELAPSED_TIME"));
            buffer.append("</th><th width='25%'>");
            buffer.append("");
            buffer.append("</th></tr><tr><td>");
            buffer.append(this.prepareCounter);
            buffer.append("</td><td>");
            buffer.append(this.df.format(new Date(this.progressStartTime)));
            buffer.append("</td><td>");
            buffer.append(this.formatElapsedTime());
            buffer.append("</td></tr></table>");
            if (action != null && action.length() > 0) {
                buffer.append(action);
            }
            buffer.append("</html>");
            this.setText(buffer.toString());
        }
        if (stage == 2) {
            this.stepBar.setIndeterminate(false);
            this.stepBar.setStringPainted(true);
            if (event.getConsider()) {
                this.stepBar.setValue(this.progressValue);
                this.mainBar.setValue(this.stepProgressMaximum * this.currentStep + this.stepProgressValue);
                if (event.getUserObject() != null) {
                    ArrayList<ProgressEvent> eventList = this.stepEventList.get(this.currentStep);
                    if (eventList == null) {
                        eventList = new ArrayList();
                        this.stepEventList.add(this.currentStep, eventList);
                    }
                    eventList.add(event);
                }
            }
            buffer = new StringBuffer();
            buffer.append("<html><h3>");
            if (this.title == null) {
                buffer.append(ResourceServices.getString(this.res, "C_EXECUTING"));
            } else {
                buffer.append(this.title);
            }
            buffer.append("</h3><table width='100%'><tr><th width='25%'></th><th width='25%'>");
            buffer.append(ResourceServices.getString(this.res, "C_START_TIME"));
            buffer.append("</th><th width='25%'>");
            buffer.append(ResourceServices.getString(this.res, "C_ELAPSED_TIME"));
            buffer.append("</th><th width='25%'>");
            buffer.append(ResourceServices.getString(this.res, "C_ESTIMATED_TIME"));
            buffer.append("</th></tr><tr><td>");
            buffer.append(this.progressValue);
            buffer.append('/');
            buffer.append(this.progressMaximum);
            buffer.append("</td><td>");
            buffer.append(this.df.format(new Date(this.progressStartTime)));
            buffer.append("</td><td>");
            buffer.append(this.formatElapsedTime());
            buffer.append("</td><td>");
            buffer.append(this.formatEstimatedTime());
            buffer.append("</td></tr></table>");
            if (action != null && action.length() > 0) {
                buffer.append(action);
            }
            buffer.append("</html>");
            this.setText(buffer.toString());
        }
        return true;
    }

    @Override
    public final boolean veto(ProgressEvent progressEvent) {
        return false;
    }

    @Override
    public final boolean isCanceled() {
        return false;
    }

    public void setProgressStartTime(long progressStartTime) {
        this.progressStartTime = progressStartTime;
    }

    public final long getProgressStartTime() {
        return this.progressStartTime;
    }

    @Override
    public void setProgressMaximum(int progressMaximum) {
        if (progressMaximum < 1) {
            progressMaximum = 1;
        }
        logger.debug((Object)("progressMaximum = " + progressMaximum));
        this.progressMaximum = progressMaximum;
        this.progressValue = 0;
        this.stepProgressMaximum += progressMaximum;
        this.stepBar.setMaximum(progressMaximum);
        this.mainBar.setMaximum(this.stepProgressMaximum * this.stepCount);
    }

    public final int getProgressMaximum() {
        return this.progressMaximum;
    }

    public final int progressIncr() {
        ++this.stepProgressValue;
        return this.progressValue++;
    }

    private void init(Frame parent) {
        this.wm = JiveFactory.getInstance();
        this.res = this.wm.getResourceBundle();
        this.bgImgUrl = this.wm.getBackgroundImageUrl();
        this.df = DateFormat.getDateTimeInstance(3, 3, this.res.getLocale());
        this.stepEventList = new ArrayList();
        this.stepEventList.add(new ArrayList());
        this.prepareCounter = 0;
        this.progressStartTime = System.currentTimeMillis();
        GridPanel panel = this.getGridPanel();
        this.info = new JEditorPane();
        this.info.setPreferredSize(new Dimension(600, 200));
        this.info.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.info.setEditable(false);
        this.info.setFocusable(false);
        panel.addComponent((JComponent)this.info, Anchor.NORTHWEST, Fill.BOTH);
        panel.incrRow();
        this.stepBar = new JProgressBar();
        this.stepBar.setIndeterminate(true);
        this.stepBar.setStringPainted(true);
        panel.addComponent((JComponent)this.stepBar, Anchor.NORTHWEST, Fill.HORIZONTAL);
        panel.incrRow();
        this.mainBar = new JProgressBar();
        this.mainBar.setStringPainted(true);
        this.mainBar.setIndeterminate(true);
        if (this.stepCount > 1) {
            panel.addComponent((JComponent)this.mainBar, Anchor.NORTHWEST, Fill.HORIZONTAL);
            panel.incrRow();
        }
        this.pack();
        this.center(parent);
    }

    private String formatEstimatedTime() {
        int max = this.stepProgressMaximum * this.stepCount;
        int current = this.stepProgressMaximum * this.currentStep + this.progressValue;
        long now = System.currentTimeMillis();
        long elapsed = now - this.progressStartTime;
        long time = 0L;
        if (current > 0) {
            time = elapsed / (long)current * (long)max;
        }
        time = this.progressStartTime + time;
        return this.df.format(new Date(time));
    }

    private String formatElapsedTime() {
        long now = System.currentTimeMillis();
        long elapsed = now - this.progressStartTime;
        long eh = (elapsed /= 1000L) / 3600L;
        long em = (elapsed %= 3600L) / 60L;
        long es = elapsed % 60L;
        StringBuffer buffer = new StringBuffer();
        buffer.append(eh);
        buffer.append(':');
        if (em < 10L) {
            buffer.append('0');
        }
        buffer.append(em);
        buffer.append(':');
        if (es < 10L) {
            buffer.append('0');
        }
        buffer.append(es);
        return buffer.toString();
    }
}

