/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class Splash
extends Window {
    private static final long serialVersionUID = 1L;
    private static Splash splash;
    private static Frame frame;
    private Font fontBold;
    private Font fontMonospaced;
    private Image image;
    private String msg = "";
    private String version;
    private boolean ready = false;
    private int height;
    private int padding = 25;
    private int width;
    private int lineHeight = 20;

    private Splash(Frame frame) {
        super(frame);
    }

    public static Splash getSplash() {
        if (splash == null) {
            frame = new Frame();
            splash = new Splash(frame);
        }
        return splash;
    }

    public void setMessage(String msg) {
        if (msg == null) {
            msg = "";
        }
        this.msg = msg;
        this.repaint(0, this.height - this.lineHeight, this.width, this.height);
    }

    public void close() {
        if (frame != null) {
            frame.dispose();
        }
    }

    public void isReady(boolean ready) {
        this.ready = ready;
    }

    public boolean isReady() {
        return this.ready;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        graphics.setFont(this.fontBold);
        graphics.drawImage(this.image, 0, 0, this);
        FontMetrics metrics = graphics.getFontMetrics();
        int strWidth = this.getStringWidth(this.version, metrics);
        graphics.drawString(this.version, this.width - strWidth, this.height - this.padding);
        graphics.setFont(this.fontMonospaced);
        strWidth = this.getStringWidth(this.msg, metrics);
        graphics.clearRect(0, this.height - this.lineHeight, this.width, this.height);
        graphics.drawString(this.msg, 10, this.height - 4);
        graphics.drawRect(0, 0, this.width - 1, this.height - 1);
        if (!this.ready) {
            Splash splash = Splash.splash;
            synchronized (splash) {
                this.ready = true;
                this.notifyAll();
            }
        }
    }

    public Splash splashImage(Image image) {
        return this.splashImage(image, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Splash splashImage(Image image, String version) {
        this.init(image, version);
        splash.setVisible(true);
        splash.toFront();
        while (!splash.isReady()) {
            try {
                Splash splash = Splash.splash;
                synchronized (splash) {
                    Splash.splash.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return splash;
    }

    private void init(Image image, String version) {
        if (image == null) {
            throw new IllegalArgumentException("Parameter image is null!");
        }
        if (version == null) {
            throw new IllegalArgumentException("The argument version may not be null!");
        }
        this.image = image;
        this.version = version;
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException oops) {
            oops.printStackTrace();
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.width = image.getWidth(this);
        this.height = image.getHeight(this);
        this.height += this.lineHeight;
        this.setSize(this.width, this.height);
        this.setLocation((dimension.width - this.width) / 2, (dimension.height - this.height) / 2);
        this.fontBold = new Font("SansSerif", 1, 14);
        this.fontMonospaced = new Font("Monospaced", 0, 12);
        this.addMouseListener(new DisposeListener());
    }

    private int getStringWidth(String str, FontMetrics metrics) {
        if (str == null) {
            throw new IllegalArgumentException("The argument str may not be null!");
        }
        if (metrics == null) {
            throw new IllegalArgumentException("The argument metrics may not be null!");
        }
        char[] chars = str.toCharArray();
        int width = 0;
        for (int i = 0; i < chars.length; ++i) {
            width += metrics.charWidth(chars[i]);
        }
        return width += this.padding;
    }

    class DisposeListener
    extends MouseAdapter {
        DisposeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseClicked(MouseEvent evt) {
            Splash splash = splash;
            synchronized (splash) {
                Splash.this.isReady(true);
                this.notifyAll();
            }
            Splash.this.dispose();
        }
    }
}

