/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.Identifier;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.dialog.AbstractDialog;
import org.dbdoclet.jive.dialog.ExceptionBox;
import org.dbdoclet.jive.dialog.SettingNode;
import org.dbdoclet.jive.dialog.settings.SettingsPanel;
import org.dbdoclet.jive.listener.SettingsListener;
import org.dbdoclet.jive.model.Settings;
import org.dbdoclet.service.ResourceServices;

public class SettingsDialog
extends AbstractDialog
implements ActionListener,
TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(SettingsDialog.class);
    private final JiveFactory wm = JiveFactory.getInstance();
    private final ResourceBundle res = this.wm.getResourceBundle();
    private JTree settingsTree;
    private final HashMap<String, DefaultMutableTreeNode> groupMap;
    private final ArrayList<SettingsPanel> panelList;
    private JPanel optionPanel;
    private Settings settings;
    private final ArrayList<SettingsListener> listenerList;

    public SettingsDialog(Frame parent, String title) {
        super((Window)parent, title);
        JPanel rootPanel = this.wm.createPanel(new Identifier("settings.root"), new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 0.3;
        gbc.weighty = 0.3;
        rootPanel.add((Component)this.createTreePanel(), gbc);
        gbc.weightx = 0.7;
        gbc.weighty = 0.7;
        rootPanel.add((Component)this.createOptionPanel(), gbc);
        this.getContentPane().add((Component)rootPanel, "Center");
        this.pack();
        this.center(parent);
        this.groupMap = new HashMap();
        this.panelList = new ArrayList();
        this.settings = new Settings(new File("settings.properties"));
        this.listenerList = new ArrayList();
    }

    public void addSettingsListener(SettingsListener listener) {
        if (listener != null) {
            this.listenerList.add(listener);
        }
    }

    public void setSettings(Settings settings) {
        if (settings == null) {
            throw new IllegalArgumentException("The argument settings must not be null!");
        }
        this.settings = settings;
        for (SettingsPanel panel : this.panelList) {
            logger.debug((Object)("panel=" + panel.getName()));
            panel.setProperties(settings);
        }
    }

    public void setSelected(TreePath treePath) {
        this.settingsTree.setSelectionPath(treePath);
        this.settingsTree.scrollPathToVisible(treePath);
    }

    public TreePath addGroup(String label) {
        if (label == null) {
            throw new IllegalArgumentException("The argument label must not be null!");
        }
        DefaultTreeModel model = (DefaultTreeModel)this.settingsTree.getModel();
        DefaultMutableTreeNode top = (DefaultMutableTreeNode)model.getRoot();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new SettingNode(label, null));
        top.add(node);
        model.reload();
        this.groupMap.put(label, node);
        TreePath treePath = new TreePath(model.getPathToRoot(node));
        return treePath;
    }

    public TreePath addPanel(String groupName, String name, SettingsPanel panel) {
        if (groupName == null) {
            throw new IllegalArgumentException("The argument groupName must not be null!");
        }
        if (name == null) {
            throw new IllegalArgumentException("The argument name must not be null!");
        }
        if (panel == null) {
            throw new IllegalArgumentException("The argument panel must not be null!");
        }
        DefaultMutableTreeNode group = this.groupMap.get(groupName);
        if (group != null) {
            DefaultTreeModel model = (DefaultTreeModel)this.settingsTree.getModel();
            panel.setProperties(this.settings);
            this.panelList.add(panel);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new SettingNode(name, panel));
            group.add(node);
            model.reload();
            TreePath treePath = new TreePath(model.getPathToRoot(node));
            return treePath;
        }
        return null;
    }

    private JPanel createTreePanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        JPanel panel = this.wm.createPanel(new Identifier("settings.tree"), new GridBagLayout());
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(new SettingNode(ResourceServices.getString(this.res, "C_SETTINGS"), null));
        DefaultTreeModel model = new DefaultTreeModel(top);
        this.settingsTree = this.wm.createTree(new Identifier("settings.tree"), model);
        this.settingsTree.setPreferredSize(new Dimension(200, 450));
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        ClassLoader loader = this.getClass().getClassLoader();
        URL iconUrl = loader.getResource("images/settingsGroupClosed.gif");
        ImageIcon icon = new ImageIcon(iconUrl, "Folder is closed.");
        renderer.setClosedIcon(icon);
        iconUrl = loader.getResource("images/settingsGroupOpen.gif");
        icon = new ImageIcon(iconUrl, "Folder is open.");
        renderer.setOpenIcon(icon);
        renderer.setLeafIcon(null);
        this.settingsTree.addTreeSelectionListener(this);
        this.settingsTree.setCellRenderer(renderer);
        this.settingsTree.setRootVisible(false);
        JScrollPane scrollPane = this.wm.createScrollPane(null, this.settingsTree);
        panel.add((Component)scrollPane, gbc);
        return panel;
    }

    private JPanel createOptionPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        JPanel panel = this.wm.createPanel(new Identifier("settings.option"), new GridBagLayout());
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.optionPanel = new JPanel();
        this.optionPanel.setLayout(new BoxLayout(this.optionPanel, 1));
        this.optionPanel.setBorder(new SoftBevelBorder(0));
        this.optionPanel.setPreferredSize(new Dimension(400, 400));
        JScrollPane scrollPane = this.wm.createScrollPane(null, this.optionPanel);
        panel.add((Component)scrollPane, gbc);
        JPanel buttonPanel = this.wm.createPanel(new Identifier("settings.buttons"), new GridBagLayout());
        buttonPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.gridy = 1;
        panel.add((Component)buttonPanel, gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(4, 4, 4, 4);
        JButton okButton = this.wm.createButton(new Identifier("settings.ok"), ResourceServices.getString(this.res, "C_OK"));
        okButton.setActionCommand("ok");
        okButton.addActionListener(this);
        okButton.setMnemonic('o');
        buttonPanel.add((Component)okButton, gbc);
        String rbstr = ResourceServices.getString(this.res, "C_CANCEL");
        JButton closeButton = this.wm.createButton(new Identifier("settings.cancel"), rbstr);
        closeButton.setActionCommand("cancel");
        closeButton.addActionListener(this);
        closeButton.setMnemonic(rbstr.charAt(0));
        gbc.gridx = 1;
        buttonPanel.add((Component)closeButton, gbc);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd != null && cmd.equals("cancel")) {
            this.setVisible(false);
            return;
        }
        if (cmd != null && cmd.equals("ok")) {
            if (this.settings == null) {
                throw new IllegalStateException("The field settings must not be null!");
            }
            this.setCursor(new Cursor(3));
            for (SettingsPanel panel : this.panelList) {
                String namespace = panel.getNamespace();
                if (namespace != null && namespace.length() > 0) {
                    Enumeration<?> e = this.settings.propertyNames();
                    while (e.hasMoreElements()) {
                        String name = (String)e.nextElement();
                        if (!name.startsWith(namespace)) continue;
                        this.settings.remove(name);
                    }
                }
                Properties properties = panel.getProperties();
                this.settings.putAll((Map<?, ?>)properties);
            }
            try {
                this.settings.store();
                for (int i = 0; i < this.listenerList.size(); ++i) {
                    SettingsListener listener = this.listenerList.get(i);
                    listener.settingsChanged(this.settings);
                }
                this.setVisible(false);
            }
            catch (IOException oops) {
                ExceptionBox ebox = new ExceptionBox(oops);
                ebox.setVisible(true);
                ebox.toFront();
            }
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        TreePath path = event.getPath();
        logger.debug((Object)("path=" + path));
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        logger.debug((Object)("node=" + node));
        if (node == null) {
            return;
        }
        SettingNode setting = (SettingNode)node.getUserObject();
        logger.debug((Object)("setting=" + setting));
        if (setting == null) {
            return;
        }
        setting.getLabel();
        SettingsPanel panel = setting.getPanel();
        if (panel == null) {
            return;
        }
        logger.debug((Object)("panel=" + panel.getName()));
        this.optionPanel.removeAll();
        this.optionPanel.invalidate();
        this.optionPanel.setLayout(new BoxLayout(this.optionPanel, 1));
        this.optionPanel.add(panel.getPanel());
        this.optionPanel.add(Box.createVerticalGlue());
        this.optionPanel.validate();
        this.optionPanel.repaint();
    }
}

