/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog;

import java.awt.Dialog;
import java.util.ResourceBundle;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.dbdoclet.jive.dialog.ErrorBox;
import org.dbdoclet.jive.dialog.ExceptionBox;
import org.dbdoclet.jive.dialog.InfoBox;
import org.dbdoclet.jive.dialog.WarningBox;
import org.dbdoclet.progress.ReportItem;
import org.dbdoclet.service.ResourceServices;

class ReportSelectionListener
implements ListSelectionListener {
    private Dialog dialogOwner;
    private ResourceBundle res;

    public ReportSelectionListener(Dialog dialogOwner, ResourceBundle res) {
        this.dialogOwner = dialogOwner;
        this.res = res;
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        JList list;
        Object obj = event.getSource();
        if (obj instanceof JList && (obj = (list = (JList)obj).getSelectedValue()) instanceof ReportItem) {
            ReportItem item = (ReportItem)obj;
            String msg = item.getMessage();
            if (msg == null) {
                msg = "";
            }
            if (item.isError() && msg.length() > 0 && item.getCause() == null) {
                ErrorBox.show(this.dialogOwner, ResourceServices.getString(this.res, "C_ERROR"), msg);
            }
            if (item.isWarning() && msg.length() > 0 && item.getCause() == null) {
                WarningBox.show(this.dialogOwner, ResourceServices.getString(this.res, "C_WARNING"), msg);
            }
            if (item.isSuccess() && msg.length() > 0 && item.getCause() == null) {
                InfoBox.show(this.dialogOwner, ResourceServices.getString(this.res, "C_INFORMATION"), msg);
            }
            if (item.getCause() != null) {
                ExceptionBox ebox = new ExceptionBox(this.dialogOwner, item.getCause());
                ebox.setVisible(true);
                ebox.toFront();
            }
        }
    }
}

