/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog;

import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.dbdoclet.jive.dialog.ReportDialog;
import org.dbdoclet.progress.ReportItem;
import org.dbdoclet.service.ResourceServices;

class ReportItemRenderer
extends JLabel
implements ListCellRenderer<ReportItem> {
    private static final long serialVersionUID = 1L;
    private ImageIcon errorIcon;
    private ImageIcon warningIcon;
    private ImageIcon successIcon;

    public ReportItemRenderer() {
        this.setOpaque(true);
        URL iconUrl = ResourceServices.getResourceAsUrl("/images/errorReportItem.jpg", ReportDialog.class.getClassLoader());
        this.errorIcon = new ImageIcon(iconUrl, "error report item");
        iconUrl = ResourceServices.getResourceAsUrl("/images/warningReportItem.jpg", ReportDialog.class.getClassLoader());
        this.warningIcon = new ImageIcon(iconUrl, "warning report item");
        iconUrl = ResourceServices.getResourceAsUrl("/images/successReportItem.jpg", ReportDialog.class.getClassLoader());
        this.successIcon = new ImageIcon(iconUrl, "success report item");
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends ReportItem> list, ReportItem value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof ReportItem) {
            ReportItem item = value;
            if (item.isError() && this.errorIcon != null) {
                this.setIcon(this.errorIcon);
            }
            if (item.isWarning() && this.warningIcon != null) {
                this.setIcon(this.warningIcon);
            }
            if (item.isSuccess() && this.successIcon != null) {
                this.setIcon(this.successIcon);
            }
            this.setText(" " + value.toString());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
        }
        return this;
    }
}

