/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.dbdoclet.jive.Anchor;
import org.dbdoclet.jive.Fill;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.dialog.AbstractDialog;
import org.dbdoclet.jive.dialog.ReportItemRenderer;
import org.dbdoclet.jive.dialog.ReportSelectionListener;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.progress.ReportItem;
import org.dbdoclet.service.ResourceServices;

public class ReportDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private JEditorPane info;
    private JList<ReportItem> eventListBox;
    private GridPanel panel;
    private URL backgroundImageUrl;
    private int width = 700;
    private int errors = 0;
    private int warnings = 0;
    private int successful = 0;
    private int total = 0;
    private ReportItem[] listData;

    public ReportDialog(Frame parent, String title, String msg, List<ReportItem> eventList) throws IOException {
        this(parent, title, msg, null, eventList);
    }

    public ReportDialog(Frame parent, String title, String msg, URL backgroundImageUrl, List<ReportItem> eventList) throws IOException {
        super((Window)parent, title, true);
        if (title == null) {
            throw new IllegalArgumentException("The argument title must not be null!");
        }
        if (msg == null) {
            throw new IllegalArgumentException("The argument msg must not be null!");
        }
        if (eventList == null) {
            throw new IllegalArgumentException("The argument eventList must not be null!");
        }
        this.backgroundImageUrl = backgroundImageUrl;
        this.init(parent, title, msg, eventList);
    }

    private void processEventList(List<ReportItem> eventList) {
        ArrayList<ReportItem> errorList = new ArrayList<ReportItem>();
        ArrayList<ReportItem> warningList = new ArrayList<ReportItem>();
        ArrayList<ReportItem> successList = new ArrayList<ReportItem>();
        for (ReportItem obj : eventList) {
            if (!(obj instanceof ReportItem)) continue;
            ReportItem item = obj;
            if (item.isError()) {
                errorList.add(item);
            }
            if (item.isWarning()) {
                warningList.add(item);
            }
            if (!item.isSuccess()) continue;
            successList.add(item);
        }
        ArrayList<ReportItem> globalList = new ArrayList<ReportItem>();
        globalList.addAll(errorList);
        globalList.addAll(warningList);
        globalList.addAll(successList);
        this.listData = errorList.toArray(new ReportItem[0]);
        this.errors = errorList.size();
        this.warnings = warningList.size();
        this.successful = successList.size();
        this.total = this.listData.length;
    }

    private void init(Frame parent, String title, String msg, List<ReportItem> eventList) throws IOException {
        this.processEventList(eventList);
        URL iconUrl = this.errors > 0 ? ResourceServices.getResourceAsUrl("/images/errorBoxHeaderBackground.jpg", ReportDialog.class.getClassLoader()) : (this.warnings > 0 ? ResourceServices.getResourceAsUrl("/images/warningBoxHeaderBackground.jpg", ReportDialog.class.getClassLoader()) : ResourceServices.getResourceAsUrl("/images/infoBoxHeaderBackground.jpg", ReportDialog.class.getClassLoader()));
        ImageIcon icon = new ImageIcon(iconUrl, "header background");
        this.setResizable(false);
        JiveFactory wm = JiveFactory.getInstance();
        ResourceBundle res = wm.getResourceBundle();
        this.panel = new GridPanel(new Insets(0, 0, 0, 0));
        this.panel.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add(this.panel);
        JLabel background = new JLabel(icon);
        JLabel heading = new JLabel(title);
        Font font = heading.getFont();
        font = font.deriveFont(18.0f);
        heading.setFont(font);
        heading.setForeground(Color.white);
        JLayeredPane headerPane = new JLayeredPane();
        headerPane.setOpaque(true);
        headerPane.setBackground(Color.white);
        headerPane.setPreferredSize(new Dimension(this.width, 50));
        headerPane.setMinimumSize(new Dimension(this.width, 50));
        headerPane.add((Component)background, new Integer(Integer.MIN_VALUE));
        headerPane.add((Component)heading, new Integer(100));
        background.setBounds(0, 0, icon.getIconWidth(), icon.getIconHeight());
        heading.setBounds(20, 0, this.width, 50);
        this.panel.addComponent((JComponent)headerPane, Anchor.NORTHWEST, Fill.HORIZONTAL);
        this.panel.incrRow();
        this.info = new JEditorPane();
        this.info.setPreferredSize(new Dimension(600, 200));
        this.info.setBackground(Color.white);
        this.info.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.darkGray), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.info.setBackground(Color.white);
        this.info.setEditable(false);
        this.info.setFocusable(false);
        this.setText(msg);
        JScrollPane scrollPane = new JScrollPane(this.info);
        scrollPane.setBackground(Color.white);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.panel.addComponent((JComponent)scrollPane, Anchor.NORTHWEST, Fill.BOTH);
        this.panel.incrRow();
        GridPanel counterPanel = new GridPanel();
        JLabel label = new JLabel(ResourceServices.getString(res, "C_ERRORS") + ": " + this.errors);
        counterPanel.addComponent(label);
        label = new JLabel(ResourceServices.getString(res, "C_WARNINGS") + ": " + this.warnings);
        counterPanel.addComponent(label);
        label = new JLabel(ResourceServices.getString(res, "C_SUCCESSFUL") + ": " + this.successful);
        counterPanel.addComponent(label);
        label = new JLabel(ResourceServices.getString(res, "C_TOTAL") + ": " + this.total);
        counterPanel.addComponent(label);
        this.panel.addComponent((JComponent)counterPanel, Anchor.NORTHWEST, Fill.HORIZONTAL);
        this.panel.incrRow();
        this.eventListBox = new JList<ReportItem>(this.listData);
        this.eventListBox.setSelectionMode(0);
        this.eventListBox.setCellRenderer(new ReportItemRenderer());
        this.eventListBox.addListSelectionListener(new ReportSelectionListener(this, res));
        scrollPane = new JScrollPane(this.eventListBox);
        scrollPane.setBorder(BorderFactory.createEtchedBorder());
        scrollPane.setPreferredSize(new Dimension(this.width, 160));
        scrollPane.setMinimumSize(new Dimension(this.width, 160));
        this.panel.addComponent((JComponent)scrollPane, Anchor.NORTHWEST, Fill.HORIZONTAL, new Insets(2, 2, 2, 2));
        this.panel.incrRow();
        GridPanel buttonPane = new GridPanel();
        buttonPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JButton okButton = new JButton(ResourceServices.getString(res, "C_OK"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportDialog.this.setVisible(false);
                ReportDialog.this.dispose();
            }
        });
        buttonPane.addComponent((JComponent)okButton, Anchor.CENTER, Fill.NONE);
        this.panel.addComponent((JComponent)buttonPane, Anchor.NORTHWEST, Fill.HORIZONTAL);
        this.getRootPane().setDefaultButton(okButton);
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        if ((text = text.trim()).toLowerCase().startsWith("<html>")) {
            this.info.setContentType("text/html");
            Document doc = this.info.getDocument();
            if (doc instanceof HTMLDocument) {
                HTMLDocument htmlDoc = (HTMLDocument)doc;
                StyleSheet styleSheet = htmlDoc.getStyleSheet();
                Font font = this.panel.getFont();
                String fontFamily = font.getFamily();
                int fontSize = font.getSize();
                String rule = "body {";
                if (this.backgroundImageUrl != null) {
                    rule = rule + "background-image: url(" + this.backgroundImageUrl.toString() + ");";
                    rule = rule + "background-repeat: no-repeat;";
                    rule = rule + "background-position: top right;";
                }
                rule = rule + " font-family: " + fontFamily + ";" + " font-size: " + fontSize + ";" + "}";
                styleSheet.addRule(rule);
                styleSheet.addRule("h3 { color: #999999; font-size: " + fontSize + ";" + " font-weight: bold;" + " margin-bottom: 2pt;" + " padding-bottom: 2pt;" + " border: 1px solid black;" + "}");
                styleSheet.addRule("h4 { color: silver; font-size: " + fontSize + ";" + "}");
                styleSheet.addRule("p.error { color: maroon;}");
                styleSheet.addRule("p.success { color: olive;}");
                this.info.setText(text);
            }
        } else {
            this.info.setContentType("text/plain");
            this.info.setText(text);
        }
    }
}

