/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.dbdoclet.jive.Anchor;
import org.dbdoclet.jive.Colspan;
import org.dbdoclet.jive.Fill;
import org.dbdoclet.jive.dialog.DataDialog;
import org.dbdoclet.jive.dialog.property.Property;
import org.dbdoclet.jive.widget.ButtonPanel;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.jive.widget.PropertyPanel;
import org.dbdoclet.service.ResourceServices;

public class PropertyDialog
extends DataDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private PropertyPanel propertyPanel;
    private JCheckBox showAgainCheckBox;
    private JButton okButton;
    private boolean showAgainEnabled;
    private boolean canceled;
    private boolean doHideOnClose = true;

    public PropertyDialog(Dialog parent, String title, boolean modal) {
        super(parent, title, modal);
        this.init();
    }

    public PropertyDialog(Frame parent, String title) {
        super(parent, title);
        this.init();
    }

    public PropertyDialog(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.init();
    }

    public PropertyDialog(String title) {
        super((Frame)null, title);
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        GridPanel panel = this.getGridPanel();
        this.propertyPanel = new PropertyPanel();
        panel.addComponent((JComponent)this.propertyPanel, Anchor.WEST, Fill.HORIZONTAL);
        panel.incrRow();
        ButtonPanel buttonPanel = new ButtonPanel(3, this);
        panel.addComponent((JComponent)buttonPanel, Anchor.WEST, Fill.HORIZONTAL);
        panel.incrRow();
        if (this.isShowAgainEnabled()) {
            this.showAgainCheckBox = new JCheckBox(ResourceServices.getString(this.res, "C_DONT_SHOW_THIS_DIALOG_AGAIN"));
            this.showAgainCheckBox.setSelected(false);
            panel.addComponent((JComponent)this.showAgainCheckBox, Colspan.CS_2, Anchor.WEST, Fill.HORIZONTAL);
            panel.incrRow();
        }
        this.okButton = buttonPanel.getOkButton();
        this.getRootPane().setDefaultButton(this.okButton);
    }

    public void addProperty(Property property) {
        this.propertyPanel.addProperty(property);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.propertyPanel.setVisible(visible);
            this.pack();
            this.center(this.getParentWindow());
            this.okButton.requestFocus();
        }
        super.setVisible(visible);
    }

    public boolean showAgain() {
        if (this.showAgainCheckBox != null) {
            return this.showAgainCheckBox.isSelected();
        }
        return true;
    }

    public boolean isShowAgainEnabled() {
        return this.showAgainEnabled;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public void setDoHideOnClose(boolean doHideOnClose) {
        this.doHideOnClose = doHideOnClose;
    }

    public void setShowAgainEnabled(boolean showAgainEnabled) {
        this.showAgainEnabled = showAgainEnabled;
    }

    public boolean getDoHideOnClose() {
        return this.doHideOnClose;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd != null && cmd.equals("ok")) {
            this.propertyPanel.stopEditing();
            this.setCanceled(false);
            if (this.doHideOnClose) {
                this.setVisible(false);
            }
        }
        if (cmd != null && cmd.equals("cancel")) {
            this.setCanceled(true);
            this.setVisible(false);
        }
    }
}

