/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.jive.Anchor;
import org.dbdoclet.jive.Fill;
import org.dbdoclet.jive.dialog.AbstractDialog;
import org.dbdoclet.jive.text.TextServices;
import org.dbdoclet.jive.widget.ButtonPanel;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.progress.ProgressEvent;
import org.dbdoclet.progress.ProgressVetoListener;

public class ProgressBox
extends AbstractDialog
implements ActionListener,
ProgressVetoListener {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(ProgressBox.class);
    private final JProgressBar progressBar = new JProgressBar();
    private final JEditorPane info = new JEditorPane();
    private GridPanel panel;
    private URL backgroundImageUrl;
    private ButtonPanel buttonPanel;
    private boolean canceled = false;
    private int maximum;
    private long startTime;
    private int value = 0;

    public ProgressBox(final Dialog owner, final String title) {
        super((Window)owner, title, false);
        if (SwingUtilities.isEventDispatchThread()) {
            this.init(owner, title, this.backgroundImageUrl, false);
        } else {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProgressBox.this.init(owner, title, ProgressBox.this.backgroundImageUrl, false);
                    }
                });
            }
            catch (Exception oops) {
                logger.fatal((Object)"ProgressBox.ProgressBox", (Throwable)oops);
            }
        }
    }

    public ProgressBox(Frame owner, String title) {
        this(owner, title, null, false);
    }

    public ProgressBox(Frame owner, String title, URL backgroundImageUrl) {
        this(owner, title, backgroundImageUrl, false);
    }

    public ProgressBox(final Frame owner, final String title, final URL backgroundImageUrl, final boolean isModal) {
        super((Window)owner, title, isModal);
        if (SwingUtilities.isEventDispatchThread()) {
            this.init(owner, title, backgroundImageUrl, isModal);
        } else {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProgressBox.this.init(owner, title, backgroundImageUrl, isModal);
                    }
                });
            }
            catch (Exception oops) {
                logger.fatal((Object)"ProgressBox.ProgressBox", (Throwable)oops);
            }
        }
    }

    private void init(Window owner, String title, URL backgroundImageUrl, boolean isModal) {
        this.backgroundImageUrl = backgroundImageUrl;
        this.setDefaultCloseOperation(0);
        this.progressBar.setIndeterminate(true);
        Container contentPane = this.getContentPane();
        this.panel = new GridPanel();
        this.panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPane.add(this.panel);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < 80; ++i) {
            buffer.append(' ');
        }
        this.info.setBackground(Color.white);
        this.info.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.darkGray), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.info.setEditable(false);
        this.info.setFocusable(false);
        this.info.setText(buffer.toString());
        this.panel.addComponent((JComponent)this.info, Anchor.CENTER, Fill.BOTH);
        this.panel.incrRow();
        this.panel.addComponent((JComponent)this.progressBar, Anchor.CENTER, Fill.HORIZONTAL);
        this.panel.incrRow();
        this.buttonPanel = new ButtonPanel(2, this);
        this.panel.addComponent((JComponent)this.buttonPanel, Anchor.CENTER, Fill.HORIZONTAL);
        this.canceled = false;
        this.pack();
        this.setSize(new Dimension(600, 300));
        this.center(owner);
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCancelButtonEnabled(boolean enabled) {
        JButton cancel;
        if (this.buttonPanel != null && (cancel = this.buttonPanel.getCancelButton()) != null) {
            cancel.setEnabled(enabled);
        }
    }

    public void setMinimum(final int min) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.progressBar.setMinimum(min);
        } else {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProgressBox.this.progressBar.setMinimum(min);
                    }
                });
            }
            catch (Exception oops) {
                logger.fatal((Object)"ProgressBox.setMinimum", (Throwable)oops);
            }
        }
    }

    public void setIndeterminate(boolean indeterminate) {
        if (this.progressBar != null) {
            this.progressBar.setIndeterminate(indeterminate);
        }
    }

    public void setMaximum(final int max) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.progressBar.setMaximum(max);
            this.progressBar.setIndeterminate(false);
            this.progressBar.setStringPainted(true);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ProgressBox.this.progressBar.setMaximum(max);
                        ProgressBox.this.progressBar.setIndeterminate(false);
                        ProgressBox.this.progressBar.setStringPainted(true);
                    }
                });
            }
            catch (Exception oops) {
                logger.fatal((Object)"ProgressBox.setMaximum", (Throwable)oops);
            }
        }
    }

    public void setValue(final int index) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.progressBar.setValue(index);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ProgressBox.this.progressBar.setValue(index);
                    }
                });
            }
            catch (Exception oops) {
                logger.fatal((Object)"ProgressBox.setValue", (Throwable)oops);
            }
        }
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        final String msg = text = text.trim();
        if (SwingUtilities.isEventDispatchThread()) {
            TextServices.setText(this.info, msg, this.backgroundImageUrl);
        } else {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TextServices.setText(ProgressBox.this.info, msg, ProgressBox.this.backgroundImageUrl);
                    }
                });
            }
            catch (Exception oops) {
                logger.fatal((Object)"ProgressBox.setText", (Throwable)oops);
            }
        }
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        String cmd = actionEvent.getActionCommand();
        if (cmd != null && cmd.equals("cancel")) {
            this.canceled = true;
        }
    }

    public int getProgressMaximum() {
        return this.maximum;
    }

    public long getProgressStartTime() {
        return this.startTime;
    }

    @Override
    public boolean progress(ProgressEvent event) {
        this.setText(event.getAction());
        this.progressIncr();
        return true;
    }

    public int progressIncr() {
        ++this.value;
        this.setValue(this.value);
        return this.value;
    }

    @Override
    public void setProgressMaximum(int maximum) {
        this.maximum = maximum;
        this.value = 0;
        this.setValue(this.value);
        this.setMaximum(maximum);
    }

    public void setProgressStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Override
    public boolean veto(ProgressEvent event) {
        return false;
    }
}

