/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog;

import java.awt.Color;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.jive.Anchor;
import org.dbdoclet.jive.Fill;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.dialog.AbstractDialog;
import org.dbdoclet.jive.dialog.action.ActionCloseDialog;
import org.dbdoclet.jive.text.ScreenPane;
import org.dbdoclet.jive.widget.ButtonPanel;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.service.ResourceServices;
import org.dbdoclet.service.StringServices;

public class ProcessBox
extends AbstractDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final int MAX_COLUMNS = 120;
    private static Log logger = LogFactory.getLog(ProcessBox.class);
    private GridPanel panel;
    private boolean canceled = false;
    private ResourceBundle res;
    private JiveFactory wm;
    private ScreenPane screen;
    private JButton cancelButton;
    private JLabel headLabel;

    public ProcessBox(Frame owner, String title) {
        this(owner, title, false);
    }

    public ProcessBox(final Frame owner, final String title, final boolean isModal) {
        super((Window)owner, title, isModal);
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.init(owner, title, isModal);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ProcessBox.this.init(owner, title, isModal);
                    }
                });
            }
        }
        catch (Exception oops) {
            logger.fatal((Object)"ProcessBox.ProcessBox", (Throwable)oops);
        }
    }

    private void init(Frame owner, String title, boolean isModal) {
        this.wm = JiveFactory.getInstance();
        this.res = this.wm.getResourceBundle();
        this.setDefaultCloseOperation(0);
        Container contentPane = this.getContentPane();
        this.panel = new GridPanel();
        this.panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPane.add(this.panel);
        URL iconUrl = ResourceServices.getResourceAsUrl("/images/Time16.gif", ProcessBox.class.getClassLoader());
        ImageIcon icon = new ImageIcon(iconUrl, "header background");
        this.headLabel = new JLabel(ResourceServices.getString(this.res, "C_PROCESSBOX_HEADER"), icon, 10);
        this.panel.addComponent((JComponent)this.headLabel, Anchor.CENTER, Fill.HORIZONTAL);
        this.panel.incrRow();
        this.screen = new ScreenPane(120, 10);
        this.screen.setBorder(BorderFactory.createLoweredBevelBorder());
        this.screen.setBackground(Color.white);
        JScrollPane scrollPane = new JScrollPane(this.screen);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.panel.addComponent((JComponent)scrollPane, Anchor.CENTER, Fill.BOTH);
        this.panel.incrRow();
        ButtonPanel buttonPanel = new ButtonPanel(2, this);
        this.cancelButton = buttonPanel.getCancelButton();
        this.panel.addComponent((JComponent)buttonPanel, Anchor.CENTER, Fill.HORIZONTAL);
        this.canceled = false;
        this.pack();
        this.center(owner);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void waitForClose(final Object mutex) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                ActionCloseDialog action = new ActionCloseDialog(this, "close-dialog");
                action.setMutex(mutex);
                this.cancelButton.setAction(action);
                this.cancelButton.setText(ResourceServices.getString(this.res, "C_CLOSE"));
                this.headLabel.setText(ResourceServices.getString(this.res, "C_PROCESS_FINSIHED"));
                this.headLabel.setIcon(null);
            } else {
                final ProcessBox dlg = this;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ActionCloseDialog action = new ActionCloseDialog(dlg, "close");
                        action.setMutex(mutex);
                        ProcessBox.this.cancelButton.setAction(action);
                        ProcessBox.this.cancelButton.setText(ResourceServices.getString(ProcessBox.this.res, "C_CLOSE"));
                        ProcessBox.this.headLabel.setText(ResourceServices.getString(ProcessBox.this.res, "C_PROCESS_FINISHED"));
                        ProcessBox.this.headLabel.setIcon(null);
                    }
                });
            }
        }
        catch (Exception oops) {
            logger.fatal((Object)"ProcessBox.waitForClose", (Throwable)oops);
        }
    }

    public void info(String msg) {
        if (msg == null) {
            return;
        }
        if (msg.length() > 120) {
            msg = StringServices.shorten(msg, 116);
        }
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.screen.info(msg);
            } else {
                final String buf = msg;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ProcessBox.this.screen.info(buf);
                    }
                });
            }
        }
        catch (Exception oops) {
            logger.fatal((Object)"ProcessBox.info", (Throwable)oops);
        }
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        String cmd = actionEvent.getActionCommand();
        if (cmd != null && cmd.equals("cancel")) {
            this.canceled = true;
        }
    }
}

